<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Admin\AdminController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', function () {
    return view('welcome');
})->name('home');
// //  *************for common user *************//
Route::any('forgot-password', 'CommonController@forgotPassword')->name('forgot-password');
Route::get('reset-password/{id}', 'CommonController@resetPassword')->name('reset-password');
Route::post('change-password', 'CommonController@changePassword')->name('change-password');


// //  *************for admin *************//
Route::get('admin', function () {
    return redirect()->route('admin.login');
});

Route::prefix('admin')->name('admin.')->group(function(){
    Route::any('/login', [AdminController::class, 'adminLogin'])->name('login');
});
