<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\RoleController;
use App\Http\Controllers\Api\UserController;
use App\Http\Controllers\Api\PatientController;
use App\Http\Controllers\Api\SkillController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::get('roles/', [RoleController::class,'role'])->name('roles');
Route::post('register/', [UserController::class,'register'])->name('register');
Route::post('otp_chk/', [UserController::class,'otp_chk'])->name('otp_chk');
Route::post('login/', [UserController::class,'login'])->name('login');
Route::post('forgot_password/', [UserController::class,'forgot_password'])->name('forgot_password');
Route::post('forgot_password_otp/', [UserController::class,'forgot_password_otp'])->name('forgot_password_otp');
Route::post('reset_password/', [UserController::class,'reset_password'])->name('reset_password');
Route::post('resend_password/', [UserController::class,'resend_password'])->name('resend_password');
Route::post('resend_otp/', [UserController::class,'resend_otp'])->name('resend_otp');
Route::post('chk_email/', [UserController::class,'chk_email'])->name('chk_email');
Route::post('chk_otp_cbot/', [UserController::class,'chk_otp_cbot'])->name('chk_otp_cbot');
//chatbot
Route::get('patient/parent_category', [PatientController::class,'parent_category'])->name('parent_category');
Route::get('patient/category', [PatientController::class,'category'])->name('category');
Route::post('patient/sub_category', [PatientController::class,'sub_category'])->name('sub_category');
Route::post('patient/symptoms', [PatientController::class,'symptoms'])->name('symptoms');
Route::post('patient/diagnosis_2', [PatientController::class,'diagnosis_2'])->name('diagnosis_2');
Route::post('patient/suggest_doctors', [PatientController::class,'suggest_doctors'])->name('suggest_doctors');
Route::post('patient/slot_aval_for_doctor', [PatientController::class,'slot_aval_for_doctor'])->name('slot_aval_for_doctor');
Route::post('patient/booking', [PatientController::class,'booking'])->name('booking');
Route::get('patient/allergy', [PatientController::class,'allergy'])->name('allergy');
Route::get('patient/surgical_history', [PatientController::class,'surgical_history'])->name('surgical_history');
Route::get('patient/social_history', [PatientController::class,'social_history'])->name('social_history');
Route::get('patient/medication', [PatientController::class,'medication'])->name('medication');
Route::get('patient/lab_history', [PatientController::class,'lab_history'])->name('lab_history');
Route::get('patient/medical_history', [PatientController::class,'medical_history'])->name('medical_history');
Route::post('patient/quick_chat', [PatientController::class,'quick_chat'])->name('quick_chat');
Route::post('patient/generate_token_p', [PatientController::class,'generate_token_p'])->name('generate_token_p');
Route::post('doctor/urgent_booking_list', [SkillController::class,'urgent_booking_list'])->name('urgent_booking_list');
Route::post('doctor/consultation_avl', [PatientController::class,'consultation_avl'])->name('consultation_avl');
Route::post('patient/quick_chat_details', [PatientController::class,'quick_chat_details'])->name('quick_chat_details');
Route::post('patient/select_dio', [PatientController::class,'select_dio'])->name('select_dio');
Route::post('patient/problems', [PatientController::class,'problems'])->name('problems');
Route::post('patient/other_doctors', [PatientController::class,'other_doctors'])->name('other_doctors');
Route::post('patient/symptoms_part', [PatientController::class,'symptoms_part'])->name('symptoms_part');
Route::post('patient/show_data_quick_visit', [PatientController::class,'show_data_quick_visit'])->name('show_data_quick_visit');
Route::post('patient/patient_allergy_quick_chat', [PatientController::class,'patient_allergy_quick_chat'])->name('patient_allergy_quick_chat');
Route::post('patient/medical_history_quick_chat', [PatientController::class,'medical_history_quick_chat'])->name('medical_history_quick_chat');
Route::post('patient/lab_quick_chat', [PatientController::class,'lab_quick_chat'])->name('lab_quick_chat');
Route::post('patient/lab_doc_quick_chat', [PatientController::class,'lab_doc_quick_chat'])->name('lab_doc_quick_chat');
Route::post('patient/surgical_doc_quick_chat', [PatientController::class,'surgical_doc_quick_chat'])->name('surgical_doc_quick_chat');
Route::post('patient/surgical_history_quick_chat', [PatientController::class,'surgical_history_quick_chat'])->name('surgical_history_quick_chat');
Route::post('patient/medication_for_quick_chat_bot', [PatientController::class,'medication_for_quick_chat_bot'])->name('medication_for_quick_chat_bot');

Route::post('patient/sendNotificationToDoctor', [PatientController::class,'sendNotificationToDoctor'])->name('sendNotificationToDoctor');
Route::post('patient/sendNotificationToPatient', [PatientController::class,'sendNotificationToPatient'])->name('sendNotificationToPatient');

Route::post('user/change_password', [UserController::class,'change_password'])->name('change_password');
Route::post('patient/questions', [PatientController::class,'questions'])->name('questions');


Route::post('user/sendNotificationToDoctorFromQc', [PatientController::class,'sendNotificationToDoctorFromQc'])->name('sendNotificationToDoctorFromQc');




Route::get('/twlioML', [PatientController::class,'twlioML'])->name('twlioML');

Route::post('/page_content', [UserController::class,'page_content'])->name('page_content');

Route::post('/upcoming_booking_list_qc', [PatientController::class,'upcoming_booking_list_qc'])->name('upcoming_booking_list_qc');



Route::group(['middleware'=>['patient.auth','cors']],function(){
    Route::post('logout/', [UserController::class,'logout'])->name('logout');
    Route::post('patient/profile_update', [PatientController::class,'profile_update'])->name('patient_profile_update');
    Route::get('patient/color_code', [PatientController::class,'color_code'])->name('color_code');
    Route::post('patient/profile_details', [PatientController::class,'profile_details_patient'])->name('profile_details_patient');
 
    Route::post('patient/profile_extra_details', [PatientController::class,'profile_details'])->name('profile_extra_details');
    Route::post('patient/patient_allergy', [PatientController::class,'patient_allergy'])->name('patient_allergy');
    Route::post('patient/patient_surgical_history', [PatientController::class,'patient_surgical_history'])->name('patient_surgical_history');
    Route::post('patient/patient_medical_history', [PatientController::class,'patient_medical_history'])->name('patient_medical_history');
    Route::post('patient/patient_medication', [PatientController::class,'patient_medication'])->name('patient_medication');
    Route::post('patient/patient_lab_history', [PatientController::class,'patient_lab_history'])->name('patient_lab_history');
    Route::post('patient/patient_surgical_images', [PatientController::class,'patient_surgical_images'])->name('patient_surgical_images');
    Route::post('patient/patient_surgical_images', [PatientController::class,'patient_surgical_images'])->name('patient_surgical_images');
    Route::post('patient/patient_lab_result_images', [PatientController::class,'patient_lab_result_images'])->name('patient_lab_result_images');
    Route::post('patient/patient_social_history', [PatientController::class,'patient_social_history'])->name('patient_social_history');
    Route::post('patient/patient_height_details', [PatientController::class,'patient_height_details'])->name('patient_height_details');
    Route::post('patient/doctor_search', [PatientController::class,'doctor_search'])->name('doctor_search');
    Route::post('patient/doctor_profile', [PatientController::class,'doctor_profile'])->name('doctor_profile');
    Route::post('patient/location_search', [PatientController::class,'location_search'])->name('location_search');
    Route::post('patient/price_search', [PatientController::class,'price_search'])->name('price_search');

    Route::post('patient/per_doc_spl', [PatientController::class,'per_doc_spl'])->name('per_doc_spl');
    Route::post('patient/booking_patient_details_update', [PatientController::class,'booking_patient_details_update'])->name('booking_patient_details_update');
    Route::post('patient/accepted_booking_list', [PatientController::class,'accepted_booking_list'])->name('accepted_booking_list');
    Route::post('patient/consultation_search', [PatientController::class,'consultation_search'])->name('consultation_search');
    Route::post('patient/prescription_list', [PatientController::class,'prescription_list'])->name('prescription_list');
    Route::post('patient/booking_details_patient', [PatientController::class,'booking_details_patient'])->name('booking_details_patient');
    Route::post('patient/completed_booking_list', [PatientController::class,'completed_booking_list'])->name('completed_booking_list');
    Route::post('patient/doctor_details_for_rating_page', [PatientController::class,'doctor_details_for_rating_page'])->name('doctor_details_for_rating_page');
    Route::post('patient/rating_review_post', [PatientController::class,'rating_review_post'])->name('rating_review_post');
    Route::post('patient/rating_search', [PatientController::class,'rating_search'])->name('rating_search');
   
    Route::post('patient/medicine_change', [PatientController::class,'medicine_change'])->name('medicine_change');
    Route::post('patient/prescription_medicines', [PatientController::class,'prescription_medicines'])->name('prescription_medicines');
    Route::post('patient/chat_end', [PatientController::class,'chat_end'])->name('chat_end');
    Route::post('patient/doctor_search_with_spl', [PatientController::class,'doctor_search_with_spl'])->name('doctor_search_with_spl');
    Route::post('patient/message_history', [PatientController::class,'message_history'])->name('message_history');
    Route::post('patient/video_history', [PatientController::class,'video_history'])->name('video_history');
    Route::post('patient/audio_history', [PatientController::class,'audio_history'])->name('audio_history');
    Route::post('patient/order_list', [PatientController::class,'order_list'])->name('order_list');
    Route::get('patient/doctors_list', [PatientController::class,'doctors_list'])->name('doctors_list');
    Route::post('patient/add_to_fav', [PatientController::class,'add_to_fav'])->name('add_to_fav');
    Route::post('patient/list_of_fav_doctors', [PatientController::class,'list_of_fav_doctors'])->name('list_of_fav_doctors');
    Route::post('patient/chk_fav', [PatientController::class,'chk_fav'])->name('chk_fav');

    Route::post('patient/listOfNotificationForPatient', [PatientController::class,'listOfNotificationForPatient'])->name('listOfNotificationForPatient');
    Route::post('patient/doctor_with_skill', [PatientController::class,'doctor_with_skill'])->name('doctor_with_skill');

    Route::post('patient/cancel_booking', [PatientController::class,'cancel_booking'])->name('cancel_booking');

    Route::post('patient/create_stripe_payment', [PatientController::class,'create_stripe_payment'])->name('create_payment');

    Route::post('patient/list_of_account_details', [PatientController::class,'list_of_account_details'])->name('list_of_account_details');
    Route::post('patient/save_account_details', [PatientController::class,'save_account_details'])->name('save_account_details');


    Route::post('patient/set_account_default', [PatientController::class,'set_account_default'])->name('set_account_default');
    

    Route::post('patient/get_account_default', [PatientController::class,'get_account_default'])->name('get_account_default');

    Route::post('patient/pay_now', [PatientController::class,'pay_now'])->name('pay_now');
 
    
});


Route::group(['middleware'=>['doctor.auth','cors']],function(){
    Route::post('logout/', [UserController::class,'logout'])->name('logout');
    Route::get('doctor/skill_specialization', [SkillController::class,'skills'])->name('skills');
    Route::post('doctor/profile_details_doctor', [SkillController::class,'profile_details_doctor'])->name('profile_details_doctor');
    Route::post('doctor/profile_update_doctor', [SkillController::class,'profile_update_doctor'])->name('profile_update_doctor');
    Route::post('doctor/doctor_speciality', [SkillController::class,'doctor_speciality'])->name('doctor_speciality');
    Route::post('doctor/doctor_certificates', [SkillController::class,'doctor_certificates'])->name('doctor_certificates');
    Route::post('doctor/routes', [SkillController::class,'routes'])->name('routes');
    Route::post('doctor/medicine_add', [SkillController::class,'medicine_add'])->name('medicine_add');
    Route::post('doctor/medicine_details', [SkillController::class,'medicine_details'])->name('medicine_details');
    Route::post('doctor/availability', [SkillController::class,'availability'])->name('availability');
    Route::post('doctor/availability_get', [SkillController::class,'availability_get'])->name('availability_get');
    Route::post('doctor/availability_update', [SkillController::class,'availability_update'])->name('availability_update');
    Route::post('doctor/availability_delete', [SkillController::class,'availability_delete'])->name('availability_delete');
    Route::post('doctor/availability_time_slot_pm', [SkillController::class,'availability_time_slot_pm'])->name('availability_time_slot_pm');
    Route::post('doctor/availability_time_slot_am', [SkillController::class,'availability_time_slot_am'])->name('availability_time_slot_am');
    Route::post('doctor/fees_update', [SkillController::class,'fees_update'])->name('fees_update');
    Route::post('doctor/fees_get', [SkillController::class,'fees_get'])->name('fees_get');
    Route::post('doctor/booking_list', [SkillController::class,'booking_list'])->name('booking_list');
    Route::post('doctor/booking_details', [SkillController::class,'booking_details'])->name('booking_details');
    Route::post('doctor/booking_accepted', [SkillController::class,'booking_accepted'])->name('booking_accepted');
    Route::post('doctor/booking_rejected', [SkillController::class,'booking_rejected'])->name('booking_rejected');
    Route::post('doctor/booking_list_completed_doctor', [SkillController::class,'booking_list_completed_doctor'])->name('booking_list_completed_doctor');
    Route::post('doctor/booking_list_rejected', [SkillController::class,'booking_list_rejected'])->name('booking_list_rejected');
    Route::post('doctor/generate_prescription', [SkillController::class,'generate_prescription'])->name('generate_prescription');
    Route::post('doctor/prescription_view', [SkillController::class,'prescription_view'])->name('prescription_view');
    Route::post('doctor/medicine_delete', [SkillController::class,'medicine_delete'])->name('medicine_delete');
    Route::post('doctor/generate_token', [SkillController::class,'generate_token'])->name('generate_token');
    Route::post('doctor/availability_get_list', [SkillController::class,'availability_get_list'])->name('availability_get_list');
    Route::post('doctor/availability_time_slot_d', [SkillController::class,'availability_time_slot_d'])->name('availability_time_slot_d');
    Route::post('doctor/message_history', [SkillController::class,'message_history'])->name('message_history_d');
    Route::post('doctor/video_history', [SkillController::class,'video_history'])->name('video_history_d');
    Route::post('doctor/audio_history', [SkillController::class,'audio_history'])->name('audio_history_d');

    

    Route::post('doctor/video_upcoming_booking_list', [SkillController::class,'video_upcoming_booking_list'])->name('video_upcoming_booking_list');
    Route::post('doctor/add_multiple_avl', [SkillController::class,'add_multiple_avl'])->name('add_multiple_avl');
    Route::post('doctor/save_note', [SkillController::class,'save_note'])->name('save_note');
    Route::post('doctor/get_note', [SkillController::class,'get_note'])->name('get_note');
    Route::post('doctor/order', [SkillController::class,'order'])->name('order');
    Route::post('doctor/medicine_auto_save', [SkillController::class,'medicine_auto_save'])->name('medicine_auto_save');
    Route::post('doctor/medicine_get_by_id', [SkillController::class,'medicine_get_by_id'])->name('medicine_get_by_id');
    Route::post('doctor/order_auto_save', [SkillController::class,'order_auto_save'])->name('order_auto_save');
    Route::post('doctor/chk_order_details_by_id', [SkillController::class,'chk_order_details_by_id'])->name('chk_order_details_by_id');
    Route::post('doctor/note_auto_save', [SkillController::class,'note_auto_save'])->name('note_auto_save');
    Route::post('doctor/medicine_get', [SkillController::class,'medicine_get'])->name('medicine_get');
    Route::post('doctor/medicine_update', [SkillController::class,'medicine_update'])->name('medicine_update');
    Route::post('doctor/treatments', [SkillController::class,'treatments'])->name('treatments');
    Route::post('doctor/patient_search', [SkillController::class,'patient_search'])->name('patient_search');
    Route::post('doctor/patient_by_id', [SkillController::class,'patient_by_id'])->name('patient_by_id');

    Route::post('doctor/add_to_fav_d', [SkillController::class,'add_to_fav_d'])->name('add_to_fav_d');
    Route::post('doctor/list_of_fav_patients', [SkillController::class,'list_of_fav_patients'])->name('list_of_fav_patients');
    Route::post('doctor/chk_fav_d', [SkillController::class,'chk_fav_d'])->name('chk_fav_d');


    Route::post('doctor/listOfNotificationForDoctor', [PatientController::class,'listOfNotificationForDoctor'])->name('listOfNotificationForDoctor');
    

    Route::post('doctor/quick_chat_list_upcoming', [SkillController::class,'quick_chat_list_upcoming'])->name('quick_chat_list_upcoming');

 
    Route::post('doctor/quick_chat_completed_list', [SkillController::class,'quick_chat_completed_list'])->name('quick_chat_completed_list');
    Route::post('doctor/booking_details_qc', [SkillController::class,'booking_details_qc'])->name('booking_details_qc');
    Route::post('doctor/generate_prescription_non', [SkillController::class,'generate_prescription_non'])->name('generate_prescription_non');
    Route::post('doctor/booking_list_home_page', [SkillController::class,'booking_list_home_page'])->name('booking_list_home_page');

    

}); 