<?php

use App\Http\Controllers\Admin\AdminController;
use App\Http\Controllers\Admin\UserController;
use App\Http\Controllers\Admin\ServiceController;

use App\Http\Controllers\Admin\AppointmentController;
use App\Http\Controllers\Admin\CmsController;
use App\Http\Controllers\Admin\ColorCodeController;
use App\Http\Controllers\Admin\SiteSettingsController;
use App\Http\Controllers\Admin\FAQController;
use App\Http\Controllers\Admin\CommissionController;
use App\Http\Controllers\Admin\AllergiesController;
use App\Http\Controllers\Admin\SurgeryController;
use App\Http\Controllers\Admin\SocialhistoryController;
use App\Http\Controllers\Admin\LabController;
use App\Http\Controllers\Admin\MedicationController;
use App\Http\Controllers\Admin\MedicalController;
use App\Http\Controllers\Admin\BodyPartController;






Route::middleware(['isAdmin:siteAdmin', "can:isAdmin"])->namespace('Admin')->prefix('admin')->name('admin.')->group(function () {
    Route::get('dashboard', [AdminController::class, 'index'])->name('dashboard');
    // Route::get('test/{mail}', 'AdminController@test')->name('test');

    Route::get('profile', 'AdminController@profile')->name('profile');
    Route::post('profile', 'AdminController@updateProfile')->name('updateProfile');
    Route::match(['get', 'post'], 'settings', 'AdminController@settings')->name('settings');
    Route::get('logout', [AdminController::class, 'logout'])->name('logout');

    Route::get('users/{type}', [UserController::class, 'userList'])->name('users');


    //doctors
    Route::get('unapproved_doctors', [UserController::class, 'unappropved_doctors'])->name('unappropved_doctors');
    Route::get('doctor/view/{id}', [UserController::class, 'doctor_view_pending'])->name('doctor.view');
    Route::get('doctor/validate/{id}', [UserController::class, 'doctor_validate'])->name('doctor.validate');

    Route::get('approved_doctor/view/{id}', [UserController::class, 'approved_doctor_view'])->name('approved.doctor.view');
    Route::get('approved_doctors', [UserController::class, 'appropved_doctors'])->name('appropved_doctors');
    Route::get('doctor/unapproved/{id}', [UserController::class, 'unapproved'])->name('doctor.unapproved');
    Route::get('doctor/edit/{id}', [UserController::class, 'doctor_edit'])->name('doctor.edit');
    Route::post('doctor_update', [UserController::class, 'doctor_update'])->name('doctor.update');
    Route::get('doctor/delete/{id}', [UserController::class, 'doctor_delete'])->name('doctor.delete');
    Route::get('doctor/discard/{id}', [UserController::class, 'doctor_discard'])->name('doctor.discard');
    Route::post('doctor_disappropved', [UserController::class, 'doctor_disappropved'])->name('doctor.doctor_disappropved');

    //sub admin
    Route::get('sub_admins', [UserController::class, 'admins'])->name('sub_admin');
    Route::get('sub_admin_create', [UserController::class, 'admin_create'])->name('admin_create');
    Route::post('admin_store', [UserController::class, 'admin_store'])->name('admin_store');
    Route::get('sub_admin_edit/{id}', [UserController::class, 'admin_edit'])->name('admin_edit');
    Route::post('admin_update', [UserController::class, 'admin_update'])->name('admin_update');
    Route::get('give_permission/{id}', [UserController::class, 'give_permission'])->name('give_permission');
    Route::post('give_permission', [UserController::class, 'give_permission_post'])->name('give_permission_post');
    Route::get('admin_status/{id}/{status}', [UserController::class, 'admin_status'])->name('admin_status');

    //patient
    Route::get('patient/view/{id}', [UserController::class, 'patient_view'])->name('patient.view');
    Route::get('patient/edit/{id}', [UserController::class, 'patient_edit'])->name('patient.edit');
    Route::post('patient_update', [UserController::class, 'patient_update'])->name('patient_update');
    Route::get('patient_status/{id}/{status}', [UserController::class, 'patient_status'])->name('patient_status');
    Route::get('patient/appointment_list/{id}', [UserController::class, 'appointment_list'])->name('patient.appointment_list');
    Route::get('patient', [UserController::class, 'patient'])->name('patient');
    Route::get('patient/create', [UserController::class, 'patient_create'])->name('patient_create');
    Route::get('patient/surgery_history/{id}', [UserController::class, 'surgery_history'])->name('surgery_history');


    //appointment

        Route::get('appointment', [AppointmentController::class, 'appointments'])->name('appointment');
        Route::get('appointment/view/{id}', [AppointmentController::class, 'appointments_view'])->name('appointment_view');
  
    
    

   



    //Quick Visit
    Route::get('q_appointment', [AppointmentController::class, 'q_appointment'])->name('mng_quick_visit');

    //color code
    Route::get('color_code', [ColorCodeController::class, 'index'])->name('color_code');
    Route::get('color_code/add', [ColorCodeController::class, 'colorAdd'])->name('colorAdd');
    Route::post('colorCreate', [ColorCodeController::class, 'colorCreate'])->name('colorCreate');
    Route::get('color_code/edit/{id}', [ColorCodeController::class, 'colorEdit'])->name('colorEdit');
    Route::get('color_code/delete/{id}', [ColorCodeController::class, 'colorDelete'])->name('colorDelete');
    Route::get('color_status/{id}/{status}', [ColorCodeController::class, 'color_status'])->name('color_status');
    Route::get('color_code/list/{id}', [ColorCodeController::class, 'color_code_list'])->name('color_code_list');

    Route::get('med_ch_rq', [ColorCodeController::class, 'med_ch_rq'])->name('med_ch_rq');
    Route::get('med_ch_rq/{id}', [ColorCodeController::class, 'med_ch_rq_id'])->name('med_ch_rq_id');

    Route::get('ch_rq/{id_m}/{id}', [ColorCodeController::class, 'ch_rq'])->name('ch_rq');
    Route::post('ch_rq_post', [ColorCodeController::class, 'ch_rq_post'])->name('ch_rq_post');

    //site settings
    Route::group(array('prefix' => 'site-settings', 'before' => 'site-settings'), function () {
        Route::get('index', [SiteSettingsController::class, 'index'])->name('site_settings_list');
        Route::get('create', [SiteSettingsController::class, 'create'])->name('site_settings_create');
        Route::get('view/{id}', [SiteSettingsController::class, 'view'])->name('site_settings_view');
        Route::get('edit/{id}', [SiteSettingsController::class, 'edit'])->name('site_settings_edit');
        Route::post('store', [SiteSettingsController::class, 'store'])->name('site_settings_store');
    });

    Route::group(array('prefix' => 'differential_diagnosis', 'before' => 'differential_diagnosis'), function () {
        Route::get('list', [BodyPartController::class, 'symptoms'])->name('symptoms');
        Route::get('status/{id}/{status}', [BodyPartController::class, 'symptom_status'])->name('symptom_status');
        Route::get('add', [BodyPartController::class, 'symptoms_add'])->name('symptoms.add');
        Route::post('create', [BodyPartController::class, 'symptoms_create'])->name('symptoms.create');
        Route::get('edit/{id}', [BodyPartController::class, 'symptoms_edit'])->name('symptoms.edit');
        Route::get('delete/{id}', [BodyPartController::class, 'symptoms_delete'])->name('symptoms.delete');
        Route::post('update', [BodyPartController::class, 'symptoms_update'])->name('symptoms.update');
        Route::get('import_diagnosis', [BodyPartController::class, 'import_diagnosis'])->name('import_diagnosis');
        Route::post('import_diagnosis_post', [BodyPartController::class, 'import_diagnosis_post'])->name('import_diagnosis_post');
    });

    Route::group(array('prefix' => 'type', 'before' => 'type'), function () {
        Route::get('list', [BodyPartController::class, 's_type'])->name('s_type');
        Route::get('add', [BodyPartController::class, 's_add'])->name('s_type.add');
        Route::post('create', [BodyPartController::class, 's_create'])->name('s.create');
        Route::get('edit/{id}', [BodyPartController::class, 's_edit'])->name('s.edit');
        Route::get('delete/{id}', [BodyPartController::class, 's_delete'])->name('s.delete');
        Route::get('import_questions', [BodyPartController::class, 'import_questions'])->name('import_questions');
        Route::post('import_questions_post', [BodyPartController::class, 'import_questions_post'])->name('import_questions_post');
    });
    Route::get('questions/', [BodyPartController::class, 'questions'])->name('questions');



    Route::group(array('prefix' => 'allergies', 'before' => 'allergies'), function () {
        Route::get('index', [AllergiesController::class, 'index'])->name('allergies');
        Route::get('add', [AllergiesController::class, 'add'])->name('allergy.add');
        Route::post('addAllergy', [AllergiesController::class, 'addAllergy'])->name('allergy.addAllergy');
        Route::get('status/{id}/{status}', [AllergiesController::class, 'status_update'])->name('allergy.status_update');
        Route::get('edit/{id}/', [AllergiesController::class, 'edit'])->name('allergy.edit');
        Route::post('editAllergy', [AllergiesController::class, 'editAllergy'])->name('allergy.editAllergy');
        Route::get('import', [AllergiesController::class, 'import'])->name('allergy.import');
        Route::post('exportAllergy', [AllergiesController::class, 'exportAllergy'])->name('exportAllergy');
    });

    Route::group(array('prefix' => 'surgery', 'before' => 'surgery'), function () {
        Route::get('index', [SurgeryController::class, 'index'])->name('surgeries');
        Route::get('add', [SurgeryController::class, 'add'])->name('surgery.add');
        Route::post('create', [SurgeryController::class, 'addSurgery'])->name('surgery.create');
        Route::get('status/{id}/{status}', [SurgeryController::class, 'status_update'])->name('surgery.status_update');
        Route::get('edit/{id}/', [SurgeryController::class, 'edit'])->name('surgery.edit');
        Route::post('editSurgery', [SurgeryController::class, 'editSurgery'])->name('surgery.editSurgery');
        Route::get('import', [SurgeryController::class, 'import'])->name('surgery.import');
        Route::post('exportSurgery', [SurgeryController::class, 'exportSurgery'])->name('exportSurgery');
    });

    Route::group(array('prefix' => 'social_history', 'before' => 'social_history'), function () {
        Route::get('index', [SocialhistoryController::class, 'index'])->name('social_history');
        Route::get('add', [SocialhistoryController::class, 'add'])->name('social_history.add');
        Route::post('create', [SocialhistoryController::class, 'addSocial'])->name('social_history.create');
        Route::get('status/{id}/{status}', [SocialhistoryController::class, 'status_update'])->name('social_history.status_update');
        Route::get('edit/{id}/', [SocialhistoryController::class, 'edit'])->name('social_history.edit');
        Route::post('editSocial', [SocialhistoryController::class, 'editSocial'])->name('social_history.editSocial');
        Route::get('import', [SocialhistoryController::class, 'import'])->name('social_history.import');
        Route::post('exportSocial_history', [SocialhistoryController::class, 'exportSocial_history'])->name('exportSocial_history');
    });
    Route::group(array('prefix' => 'lab', 'before' => 'lab'), function () {
        Route::get('index', [LabController::class, 'index'])->name('lab');
        Route::get('add', [LabController::class, 'add'])->name('lab.add');
        Route::post('create', [LabController::class, 'addLab'])->name('lab.create');
        Route::get('status/{id}/{status}', [LabController::class, 'status_update'])->name('lab.status_update');
        Route::get('edit/{id}/', [LabController::class, 'edit'])->name('lab.edit');
        Route::post('editLab', [LabController::class, 'editLab'])->name('lab.editLab');
        Route::get('import', [LabController::class, 'import'])->name('export_lab');
        Route::post('exportLab', [LabController::class, 'exportLab'])->name('exportLab');
    });
    Route::group(array('prefix' => 'medication', 'before' => 'medication'), function () {
        Route::get('index', [MedicationController::class, 'index'])->name('medication');
        Route::get('add', [MedicationController::class, 'add'])->name('medication.add');
        Route::post('create', [MedicationController::class, 'addMedication'])->name('medication.create');
        Route::get('status/{id}/{status}', [MedicationController::class, 'status_update'])->name('medication.status_update');
        Route::get('edit/{id}/', [MedicationController::class, 'edit'])->name('medication.edit');
        Route::post('editMedication', [MedicationController::class, 'editMedication'])->name('editMedication');
        Route::get('import', [MedicationController::class, 'import'])->name('medication.import');
        Route::post('exportMedication', [MedicationController::class, 'exportMedication'])->name('exportMedication');
    });
    Route::group(array('prefix' => 'medical', 'before' => 'medical'), function () {
        Route::get('index', [MedicalController::class, 'index'])->name('medical');
        Route::get('add', [MedicalController::class, 'add'])->name('medical.add');
        Route::post('create', [MedicalController::class, 'addMedical'])->name('medical.create');
        Route::get('status/{id}/{status}', [MedicalController::class, 'status_update'])->name('medical.status_update');
        Route::get('edit/{id}/', [MedicalController::class, 'edit'])->name('medical.edit');
        Route::post('editMedical', [MedicalController::class, 'editMedical'])->name('editMedical');
        Route::get('import', [MedicalController::class, 'import'])->name('export_medical');
        Route::post('exportMedical', [MedicalController::class, 'exportMedical'])->name('exportMedical');
    });
    Route::group(array('prefix' => 'symptoms', 'before' => 'symptoms'), function () {
        Route::get('index', [BodyPartController::class, 'index'])->name('body_cat');
        Route::get('add', [BodyPartController::class, 'add'])->name('body_cat.add');
        Route::post('create', [BodyPartController::class, 'create'])->name('body_cat.create');
        Route::get('status/{id}/{status}', [BodyPartController::class, 'status'])->name('body_cat.status');
        Route::get('edit/{id}/', [BodyPartController::class, 'edit'])->name('body_cat.edit');
        Route::post('editBodyCat', [BodyPartController::class, 'editBodyCat'])->name('editBodyCat');
        Route::get('delete/{id}', [BodyPartController::class, 'body_cat_delete'])->name('body_cat_delete');

        Route::post('import_post', [BodyPartController::class, 'body_cat_import_post'])->name('body_cat_import_post');
    });



    Route::get('import', [BodyPartController::class, 'body_cat_import'])->name('import');




    Route::group(array('prefix' => 'chief_complaint', 'before' => 'chief_complaint'), function () {
        Route::get('list', [BodyPartController::class, 'p_cat_list'])->name('p_cat_list');

        Route::get('list_a', [BodyPartController::class, 'p_cat_list_a'])->name('p_cat_list_a');
        Route::get('list_p', [BodyPartController::class, 'p_cat_list_p'])->name('p_cat_list_p');


        Route::get('add', [BodyPartController::class, 'p_cat_add'])->name('p_cat_add');
        Route::post('create', [BodyPartController::class, 'p_cat_create'])->name('p_cat_create');
        Route::get('status/{id}/{status}', [BodyPartController::class, 'p_cat_status'])->name('p_cat_status');
        Route::get('edit/{id}', [BodyPartController::class, 'p_cat_edit'])->name('p_cat_edit');
        Route::post('update', [BodyPartController::class, 'p_cat_update'])->name('p_cat_update');
        Route::get('delete/{id}', [BodyPartController::class, 'p_cat_delete'])->name('p_cat_delete');
        Route::get('import/', [BodyPartController::class, 'import_problems'])->name('problems_import');
        Route::post('import_post/', [BodyPartController::class, 'import_problems_post'])->name('import_problems_post');
    });
    Route::group(array('prefix' => 'diagnosis', 'before' => 'diagnosis'), function () {
        Route::get('list', [BodyPartController::class, 'sub_cat'])->name('sub_cat_index');
        Route::get('add', [BodyPartController::class, 'sub_cat_add'])->name('sub_cat_add');
        Route::post('create', [BodyPartController::class, 'sub_cat_create'])->name('body_subcat.create');
        Route::get('status/{id}/{status}', [BodyPartController::class, 'body_subcat_status'])->name('body_subcat.status');
        Route::get('edit/{id}/', [BodyPartController::class, 'subcat_edit'])->name('body_subcat.edit');
        Route::post('editBodySubCat', [BodyPartController::class, 'editBodySubCat'])->name('editBodySubCat');

        Route::get('delete/{id}/', [BodyPartController::class, 'subcat_delete'])->name('body_subcat.delete');

        Route::get('getCat', [BodyPartController::class, 'getCat'])->name('getCat');
        Route::get('import_treatments', [BodyPartController::class, 'import_treatments'])->name('import_treatments');
        Route::post('import_treatments_post', [BodyPartController::class, 'import_treatments_post'])->name('import_treatments_post');
    });
    //reason
    Route::get('reasons', [UserController::class, 'reasons'])->name('reasons');
    Route::get('reasons_add', [UserController::class, 'reasons_add'])->name('reasons.add');
    Route::post('reasons_create', [UserController::class, 'reasons_create'])->name('reasons.create');
    Route::get('reasons/edit/{id}', [UserController::class, 'reasons_edit'])->name('reasons.edit');
    Route::get('reason_status/{id}/{status}', [UserController::class, 'reason_status'])->name('reason_status');

    //complain
    Route::get('complain_list/', [UserController::class, 'complain_list'])->name('complain_list');
    Route::get('complain_view/{id}', [UserController::class, 'complain_view'])->name('complain_view');

    Route::get('route', [UserController::class, 'route'])->name('route');
    Route::get('route_add', [UserController::class, 'route_add'])->name('route.add');
    Route::post('route_store', [UserController::class, 'route_store'])->name('route.store');
    Route::post('route_update', [UserController::class, 'route_update'])->name('route.update');
    Route::get('route/edit/{id}', [UserController::class, 'route_edit'])->name('route.edit');
    Route::get('route/delete/{id}', [UserController::class, 'route_delete'])->name('route.delete');

    //contact info
    Route::get('info', [UserController::class, 'contact_info'])->name('info');
    Route::get('info/edit/{id}', [UserController::class, 'contact_info_edit'])->name('contact.info.edit');
    Route::post('contact_info', [UserController::class, 'contact_info_update'])->name('contact_info.edit');

    //contact
    Route::get('contact', [UserController::class, 'contact'])->name('contact');
    Route::get('contact/view/{id}', [UserController::class, 'contact_view'])->name('contact_view');
    Route::get('contact/delete/{id}', [UserController::class, 'contact_delete'])->name('contact_delete');
    Route::get('contact/reply/{id}', [UserController::class, 'contact_reply'])->name('contact_reply');
    Route::post('contact_reply/', [UserController::class, 'contact_reply_send'])->name('contact_reply_send');

    //commission
    Route::get('commission', [CommissionController::class, 'commission'])->name('commission');
    Route::get('commission/global', [CommissionController::class, 'global_commission'])->name('global.commission');
    Route::get('commission/global/edit/{id}', [CommissionController::class, 'global_commission_edit'])->name('global.commission.edit');
    Route::post('global_store', [CommissionController::class, 'global_store'])->name('global.store');
    Route::post('global_update', [CommissionController::class, 'global_update'])->name('global.update');
    Route::get('commission/doctor', [CommissionController::class, 'doctor_commission'])->name('doctor.commission');
    Route::post('commission_store', [CommissionController::class, 'commission_store'])->name('commission.store');
    Route::get('g_commission', [CommissionController::class, 'g_commission'])->name('global_per');
    Route::get('commission/edit/{id}', [CommissionController::class, 'commission_edit'])->name('doctor.commission.edit');

    //time slot
    Route::get('slot_time', [SiteSettingsController::class, 'slot_time'])->name('slot_time');
    Route::post('slot_time_post', [SiteSettingsController::class, 'slot_time_post'])->name('slot_time_post');





    Route::get('commission', [CommissionController::class, 'commission'])->name('commission');


    Route::match(['get', 'post'], 'users/add', [UserController::class, 'addUser'])->name('user.add');
    Route::get('users/{type}/view/{id}', [UserController::class, 'userView'])->name('user.view');
    Route::get('users/{type}/edit/{id}', [UserController::class, 'userEdit'])->name('user.edit');
    Route::get('users/approved/{id}', [UserController::class, 'approvedUser'])->name('user.approved');
    Route::post('user/update', [UserController::class, 'userUpdate'])->name('user.update');
    Route::get('user/block/{user}', [UserController::class, 'blockUser'])->name('user.block');
    Route::get('user/active/{user}', [UserController::class, 'activeUser'])->name('user.active');
    Route::match(['get', 'post'], 'user/delete/{id?}', [UserController::class, 'userDelete'])->name('user.delete');

    Route::get('verify-user/{user}', [UserController::class, 'verifyUser'])->name('user.verify-user');


    Route::match(['get', 'post'], 'news/index', 'NewsController@index')->name('news');
    Route::match(['get', 'post'], 'news/create', 'NewsController@create')->name('news.create');
    Route::match(['get', 'post'], 'news/edit/{id}', 'NewsController@edit')->name('news.edit');
    Route::match(['get', 'post'], 'news/delete/{id?}', 'NewsController@delete')->name('news.delete');


    Route::match(['get', 'post'], 'cms/index', [CmsController::class, 'index'])->name('cms');
    Route::match(['get', 'post'], 'cms/create', [CmsController::class, 'create'])->name('cms.create');
    Route::match(['get', 'post'], 'cms/edit/{id}', [CmsController::class, 'edit'])->name('cms.edit');
    Route::match(['get', 'post'], 'cms/delete/{id?}', [CmsController::class, 'delete'])->name('cms.delete');

    Route::match(['get', 'post'], 'handy-document/index', 'HandyDocumentController@index')->name('h_doc');
    Route::match(['get', 'post'], 'handy-document/create', 'HandyDocumentController@create')->name('h_doc.create');
    Route::match(['get', 'post'], 'handy-document/edit/{id}', 'HandyDocumentController@edit')->name('h_doc.edit');
    Route::match(['get', 'post'], 'handy-document/delete/{id?}', 'HandyDocumentController@delete')->name('h_doc.delete');

    Route::match(['get', 'post'], 'contact-us/index', 'ContactUsController@index')->name('c_us');
    // Route::match(['get','post'],'handy-document/create', 'HandyDocumentController@create')->name('h_doc.create');
    // Route::match(['get','post'],'handy-document/edit/{id}', 'HandyDocumentController@edit')->name('h_doc.edit');
    Route::match(['get', 'post'], 'contact-us/delete/{id?}', 'ContactUsController@delete')->name('c_us.delete');

    Route::get('/change-password', [AdminController::class, 'showChangePasswordForm'])->name('change.password');
    Route::post('/change-password', [AdminController::class, 'changePassword'])->name('changePassword');
    // Route::match(['get','post'],'/change-email','AdminController@changeEmail')->name('changeEmail');
    Route::match(['get', 'post'], '/manage-profile', [AdminController::class, 'manageProfile'])->name('manageProfile');
    Route::group(array('prefix' => 'manage-category', 'before' => 'manage-category'), function () {
        Route::any('/', 'CategoryController@index')->name('category.index');
        Route::any('details/{member_id}', 'CategoryController@show')->name('category.show');

        Route::any('add', 'CategoryController@create')->name('category.create');
        Route::any('store', 'CategoryController@store')->name('category.store');

        Route::any('edit/{member_id}', 'CategoryController@edit')->name('category.edit');
        Route::any('update/{member_id}', 'CategoryController@update')->name('category.update');
        // Route::any('destroy/{member_id}','CategoryController@destroy')->name('category.destroy');
        // Route::any('restore/{member}','CategoryController@restore')->name('category.restore');
        Route::any('active/{member_id}', 'CategoryController@active')->name('category.active');
        Route::any('inactive/{member}', 'CategoryController@inactive')->name('category.inactive');
    });

    Route::group(array('prefix' => 'subscription', 'before' => 'subscription'), function () {
        Route::any('/', 'SubscriptionController@index')->name('subscription.index');
        Route::any('details/{member_id}', 'SubscriptionController@show')->name('subscription.show');

        Route::any('add', 'SubscriptionController@create')->name('subscription.create');
        Route::any('store', 'SubscriptionController@store')->name('subscription.store');

        Route::any('edit/{member_id}', 'SubscriptionController@edit')->name('subscription.edit');
        Route::any('update/{member_id}', 'SubscriptionController@update')->name('subscription.update');
        // Route::any('destroy/{member_id}','SubscriptionController@destroy')->name('subscription.destroy');
        // Route::any('restore/{member}','SubscriptionController@restore')->name('subscription.restore');
        Route::any('active/{member_id}', 'SubscriptionController@active')->name('subscription.active');
        Route::any('inactive/{member}', 'SubscriptionController@inactive')->name('subscription.inactive');
    });

    Route::group(array('prefix' => 'feature-subscription', 'before' => 'feature-subscription'), function () {
        Route::any('/', 'FeatureSubscriptionController@index')->name('feature-subscription.index');
        Route::any('details/{member_id}', 'FeatureSubscriptionController@show')->name('feature-subscription.show');

        Route::any('add', 'FeatureSubscriptionController@create')->name('feature-subscription.create');
        Route::any('store', 'FeatureSubscriptionController@store')->name('feature-subscription.store');

        Route::any('edit/{member_id}', 'FeatureSubscriptionController@edit')->name('feature-subscription.edit');
        Route::any('update/{member_id}', 'FeatureSubscriptionController@update')->name('feature-subscription.update');
        // Route::any('destroy/{member_id}','FeatureSubscriptionController@destroy')->name('feature-subscription.destroy');
        // Route::any('restore/{member}','FeatureSubscriptionController@restore')->name('feature-subscription.restore');
        Route::any('active/{member_id}', 'FeatureSubscriptionController@active')->name('feature-subscription.active');
        Route::any('inactive/{member}', 'FeatureSubscriptionController@inactive')->name('feature-subscription.inactive');
    });

    Route::group(array('prefix' => 'coupon', 'before' => 'coupon'), function () {
        Route::any('/', 'CouponController@index')->name('coupon.index');
        Route::any('details/{member_id}', 'CouponController@show')->name('coupon.show');

        Route::any('add', 'CouponController@create')->name('coupon.create');
        Route::any('store', 'CouponController@store')->name('coupon.store');

        Route::any('edit/{member_id}', 'CouponController@edit')->name('coupon.edit');
        Route::any('update/{member_id}', 'CouponController@update')->name('coupon.update');
        // Route::any('destroy/{member_id}','CouponController@destroy')->name('coupon.destroy');
        // Route::any('restore/{member}','CouponController@restore')->name('coupon.restore');
        Route::any('send/{member_id}', 'CouponController@send')->name('coupon.send');
        Route::any('inactive/{member}', 'CouponController@inactive')->name('coupon.inactive');
    });
    Route::group(array('prefix' => 'food', 'before' => 'food'), function () {
        Route::any('/', 'FoodController@index')->name('food.index');
        Route::any('details/{id}', 'FoodController@show')->name('food.show');

        Route::any('add', 'FoodController@create')->name('food.create');
        Route::any('store', 'FoodController@store')->name('food.store');

        Route::any('edit/{id}', 'FoodController@edit')->name('food.edit');
        Route::any('update/{id}', 'FoodController@update')->name('food.update');

        Route::any('active/{id}', 'FoodController@active')->name('food.active');
        Route::any('inactive/{id}', 'FoodController@inactive')->name('food.inactive');
    });

    Route::group(array('prefix' => 'service', 'before' => 'service'), function () {
        Route::any('/', [ServiceController::class, 'index'])->name('service.index');
        Route::any('details/{id}', [ServiceController::class, 'show'])->name('service.show');

        Route::any('add', [ServiceController::class, 'create'])->name('service.create');
        Route::any('store', [ServiceController::class, 'store'])->name('service.store');

        Route::any('edit/{id}', [ServiceController::class, 'edit'])->name('service.edit');
        Route::any('update/{id}', [ServiceController::class, 'update'])->name('service.update');

        Route::any('active/{id}', [ServiceController::class, 'active'])->name('service.active');
        Route::any('inactive/{id}', [ServiceController::class, 'inactive'])->name('service.inactive');

        Route::any('delete/{id}', [ServiceController::class, 'delete'])->name('service.delete');

    });

    Route::group(array('prefix' => 'contact-us'), function () {

        Route::get('/', 'ContactUsController@index')->name('contact_us.index');
        // Route::match(['get','post'],'cms/create', 'CmsController@create')->name('cms.create');
        Route::match(['get', 'post'], '/edit/{id}', 'ContactUsController@edit')->name('contact_us.edit');
        Route::get('/show/{id}', 'ContactUsController@show')->name('contact_us.show');
        Route::match(['get', 'post'], '/delete/{id?}', 'ContactUsController@delete')->name('contact_us.delete');
    });

    Route::group(array('prefix' => 'news-letter'), function () {
        Route::get('/', 'NewsLetterController@index')->name('news_letter.index');
        // Route::match(['get','post'],'cms/create', 'CmsController@create')->name('cms.create');
        Route::match(['get', 'post'], '/edit/{id}', 'NewsLetterController@edit')->name('news_letter.edit');
        Route::get('/show/{id}', 'NewsLetterController@show')->name('news_letter.show');
        Route::match(['get', 'post'], '/delete/{id?}', 'NewsLetterController@delete')->name('news_letter.delete');
    });

    Route::group(array('prefix' => 'faq', 'before' => 'faq'), function () {
        Route::match(['get', 'post'], 'index', [FAQController::class, 'index'])->name('faq');
        Route::match(['get', 'post'], 'create', [FAQController::class, 'create'])->name('faq.create');
        Route::match(['get', 'post'], 'edit/{id}', [FAQController::class, 'edit'])->name('faq.edit');
        Route::match(['get', 'post'], 'delete/{id?}', [FAQController::class, 'delete'])->name('faq.delete');
    });

    Route::match(['get', 'post'], 'home-page-banner/index', 'HomePageBannerController@index')->name('home_page_banner');
    Route::match(['get', 'post'], 'home-page-banner/create', 'HomePageBannerController@create')->name('home_page_banner.create');
    Route::match(['get', 'post'], 'home-page-banner/edit/{id}', 'HomePageBannerController@edit')->name('home_page_banner.edit');
    Route::match(['get', 'post'], 'home-page-banner/delete/{id?}', 'HomePageBannerController@delete')->name('home_page_banner.delete');

    Route::match(['get', 'post'], 'contactus-cms', 'ContactUsController@contactUsCMS')->name('contact_us.cms');

    Route::get('review-ratings', 'ContactUsController@rating_revew_list')->name('rr.list');
    Route::get('review-rating-approve/{id}', 'ContactUsController@approveRatingReview')->name('rr.approve');

    Route::get('uses-coupon', 'CouponUsesController@Coupon_uses')->name('coupon_uses.index');
});
//  *************for admin *************//
