

<?php $__env->startSection('title', 'Appointment Details'); ?>

<?php $__env->startSection('body'); ?>

<?php $__env->startSection('header', 'Appointment Details'); ?>
<?php $__env->startSection('badge'); ?>

<li class="breadcrumb-item"><a href="<?php echo e(route('admin.appointment')); ?>">Appointment Details</a></li>
<?php $__env->stopSection(); ?>


<div class="card">

    <div class="card-body">
        <form role="form" method="POST" action="<?php echo e(route('admin.route.store')); ?>" enctype="multipart/form-data" id="cmsForm">
            <?php echo e(csrf_field()); ?>



            <div class="card-body">

                <div class="form-group row">
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Appointment Date & Time:</span>
                    <?php
                        $start_time = date('h:i a', strtotime(get_change_utc_to_timezone($appointment->slot_start, 'America/New_York')));

                        $end_time = date('h:i a', strtotime(get_change_utc_to_timezone($appointment->slot_end, 'America/New_York')));
                        ?>


                     
                        <?php echo e(date("m-d-Y",strtotime($appointment->date))); ?> (<?php echo e($start_time); ?> to <?php echo e($end_time); ?>)
                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Specialization:</span>
                    <?php echo e($appointment->specialization->name); ?>

                    </p>

                    
                   
                   
                  
                </div>
                <div class="form-group row">
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Doctor Name:</span>
                        <?php echo e($appointment->doctor->name); ?>


                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Patient Name:</span>
                        <?php echo e($appointment->patient->name); ?>


                    </p>
                </div>
                <div class="form-group row">
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Consultation Type:</span>
                        <?php echo e($appointment->consultation_type); ?>


                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Appointment Fee:</span>
                        <?php echo e($appointment->fee); ?>


                    </p>
                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>


                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorapp\resources\views/admin/appoinment/view.blade.php ENDPATH**/ ?>