<?php $__env->startSection('title', 'Color Code'); ?>

<?php $__env->startSection('body'); ?>

<?php $__env->startSection('header', 'Add Color Code'); ?>
<?php $__env->startSection('badge'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.color_code')); ?>">Color Code</a></li>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.colorAdd')); ?>">Add Color Code</a></li>
<?php $__env->stopSection(); ?>
<style>
    .card1 {
        background-color: white;
        border-radius: 4px;
        padding: 5px;
        display: flex;
        flex-direction: column;
        justify-content: center;
        align-items: center;
        box-shadow: 0 30px 30px -15px rgba(0, 0, 0, 0.3);

    }

    .code {
        list-style: none;
        padding: 0px;
        display: grid;
        grid-template-columns: repeat(5, 1fr);
        grid-gap: 20px;

    }

    .color-item {
        width: 30px;
        height: 30px;
        background-color: red;
        border-radius: 50%;
        cursor: pointer;
        transition: transform 0.3s;

    }

    .color-item:hover {
        transform: scale(1.1);
    }
</style>

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Add Color Code</h3>
    </div>
    <div class="card-body">
        <form role="form" method="POST" action="<?php echo e(route('admin.colorCreate')); ?>" enctype="multipart/form-data" id="cmsForm">
            <?php echo e(csrf_field()); ?>



            <div class="card-body row">

                <div class="col-md-6">
                    <label class="col-md-4 form-control-label" for="name">Color <span class="text-danger">*</span></label>
                    <input type="hidden" name="color" id="color" class="form-control" required>
                    <div class="col-md-8">

                        <input type="text" name="color1" id="color1" class="form-control" disabled required>
                        <?php $__errorArgs = ['color'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <div class="text-danger"><?php echo e($message); ?></div>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </div>
                    <label class="col-md-4 form-control-label" for="name">Health Condition <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" name="type" id="type" class="form-control" value="<?php echo e(old('location')); ?>" required>

                    </div>
                    
                </div>
                <div class="col-md-5">
                   
                   <div class="card card1">
                       <label class="form-control-label" for="name">Pick a Color</label>
                       <ul class="code">
                           <?php $__currentLoopData = colors(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $cl): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                           <li class="color-item" style="background-color:<?php echo e($cl->color); ?>;" id="<?php echo e($cl->color); ?>"></li>
                           <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                       </ul>

                   </div>
               </div>
                <div class="col-md-6">
                    

                </div>
              
            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script>
    window.addEventListener('load', () => {
        const colorItem = document.querySelectorAll('.color-item');
        colorItem.forEach(item => {
            item.addEventListener('click', function() {
                const idSelected = this.id;
                console.log(idSelected);
                $('#color').val(idSelected);
                $('#color1').val(idSelected);
            });

        })
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorapp\resources\views/admin/colorCode/add.blade.php ENDPATH**/ ?>