

<?php $__env->startSection('title', 'Medication'); ?>

<?php $__env->startSection('body'); ?>
<?php $__env->startSection('header', '
Medication'); ?>
<?php $__env->startSection('badge'); ?>
<li class="breadcrumb-item"><a href="">
Medication</a></li>
<?php $__env->stopSection(); ?>



<div class="card card-primary card-outline">
    
    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:20px;">


          
            <a href="<?php echo e(route('admin.medication.add')); ?>" data-toggle="tooltip" title="Add Medication" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add</a>
            <a href="<?php echo e(route('admin.medication.delete_all')); ?>" onclick="return confirm('Are you sure you want to delete all ?')" data-toggle="tooltip" title="Delete All Lab" class="btn btn-danger btn-sm"><i class="fa fa-plus"></i> Delete All</a>
            <a href="<?php echo e(route('admin.medication.import')); ?>" data-toggle="tooltip" title="Import Medication" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Import</a>
        </div>


    </div>
    <?php if(Session::has('message')): ?>
    <div class="alert alert-success">
        <?php echo e(Session::get('message')); ?> 
    </div>
    <?php endif; ?>



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Title</th>
                        <th>Type</th>
                        <th>Dose</th>
                        <th>Status</th>
                      
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>


                        <td>

                            <?php echo e($key+1); ?>


                        </td>
                        <td><?php echo e($value->title); ?></td>
                        <td><?php echo e($value->type); ?></td>
                        <td><?php echo e($value->unit); ?></td>
                        <?php if($value->status == 1): ?>
                        <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="<?php echo e(URL::to('admin/medication/status')); ?>/<?php echo e($value->id); ?>/0" style="padding-left:13px;padding-right:13px;">Active</a></td>
                        <?php else: ?>
                        <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="<?php echo e(URL::to('admin/medication/status')); ?>/<?php echo e($value->id); ?>/1">Inactive</a></td>
                        <?php endif; ?>
                       
                        <td>
                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="<?php echo e(URL::to('admin/medication/edit')); ?>/<?php echo e($value->id); ?>"> <i class="fas fa-edit"></i></a>
                            <a class="btn btn-sm btn-outline-danger" onclick="return alert('Are you sure you want to delete this ?')" data-toggle="tooltip" title="Click to delete" href="<?php echo e(URL::to('admin/medication/delete')); ?>/<?php echo e($value->id); ?>"> <i class="fa fa-trash" aria-hidden="true"></i></a>
                        </td>

                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </tbody>



            </table>

        </div>
    </div>



</div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorapp\resources\views/admin/med/index.blade.php ENDPATH**/ ?>