

<?php $__env->startSection('title', 'Manage Profile'); ?>

<?php $__env->startSection('body'); ?>
<?php $__env->startSection('header', 'Manage Profile'); ?>
<?php $__env->startSection('badge'); ?>

<li class="breadcrumb-item"><a href="<?php echo e(route('admin.manageProfile')); ?>">Manage Profile</a></li><br>

<?php $__env->stopSection(); ?>
<div class="text-right">
    <?php if(request()->user()->profile_image != ''): ?>
    <img src="../<?php echo e(request()->user()->profile_image); ?>" height="75px" width="90px" alt="logo" style="padding-right:25px;" >
    <?php else: ?>
    <img src="../images/noimage.png" height="80px" width="90px"  alt="logo" style="padding-right:25px;" >
    <?php endif; ?>

</div>
<section class="content">
    <?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>
    <div class="container-fluid">
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">Manage Profile</h3>

                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>
                   

                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form role="form" method="POST" action="<?php echo e(route('admin.manageProfile')); ?>" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Name <span  style="color:red">*</span></label>


                                <input id="name" type="text" class="form-control" name="name" value="<?php echo e(request()->user()->name); ?>" required>

                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Email</label>
                                <input id="email" type="email" class="form-control" name="email" value="<?php echo e(request()->user()->email); ?>" disabled>

                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Phone <span style="color:red">*</span></label>


                                <input id="phone" type="text" class="form-control" name="phone" maxlength="10" pattern="\d{10}" value="<?php echo e(request()->user()->phone); ?>" required>

                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Address <span style="color:red">*</span></label>


                                <input id="address" type="text" class="form-control" name="address" value="<?php echo e(request()->user()->address); ?>" required>

                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Profile Image</label>


                                <input id="logo" type="file" class="form-control-file" name="logo" >
                                <?php if($errors->has('logo')): ?>
                                <span class="help-block">
                                    <div class="text-danger">
                                        <strong><?php echo e($errors->first('logo')); ?></strong>
                                    </div>
                                </span>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-md-6">




                            <?php if(request()->user()->profile_image != ''): ?>
                            <img src="../<?php echo e(request()->user()->profile_image); ?>" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                            <?php else: ?>
                            <img src="../images/noimage.png" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                            <?php endif; ?>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Logo</label>


                                <input id="logo_w" type="file" class="form-control-file" name="logo_w">
                               
                            </div>
                        </div>

                        <div class="col-md-6">




                            <?php if(getSetting('logo') != ''): ?>
                            <img src="<?php echo e(asset('Images/logo/' . getSetting('logo'))); ?>" height="128px" width="128px" class="img-circle" alt="User Image">
                            <?php else: ?>
                            <img src="../images/noimage.png" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                            <?php endif; ?>
                        </div>

                        <button type="submit" class="btn btn-primary">
                            Save
                        </button>
                        &nbsp;&nbsp;
                        <a class="btn btn-warning" href="<?php echo e(route('admin.change.password')); ?>">
                            Change Password
                        </a>
                    </div>

            </div>
            </form>
        </div>

    </div>

    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\doctorapp\resources\views/admin/auth/manage_profile.blade.php ENDPATH**/ ?>