

<?php $__env->startSection('title', 'Manage Commission'); ?>

<?php $__env->startSection('body'); ?>
<?php $__env->startSection('header', '
Manage Commission'); ?>
<?php $__env->startSection('badge'); ?>
<li class="breadcrumb-item"><a href="">
       Manage Commission</a></li>
<?php $__env->stopSection(); ?>



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">
        Commission List</h3>
    </div>
    <?php if(Session::has('message')): ?>
    <div class="alert alert-success">
        <?php echo e(Session::get('message')); ?> 
    </div>
    <?php endif; ?>
    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:15px">


            <div class="btn-group">


                <a href="" data-toggle="tooltip" title="" class="btn btn-default btn-sm" data-original-title="Refresh"><i class="fas fa-sync-alt"></i></a>
                <a style="margin-left:12px" href="<?php echo e(route('admin.global.commission')); ?>" data-toggle="tooltip" title="" class="btn btn-success btn-sm" data-original-title="Set Global Commission"><i class="fas fa-plus-square"></i> Global Commission</a>
            </div>
            <a href="<?php echo e(route('admin.doctor.commission')); ?>" data-toggle="tooltip" title="" class="btn btn-info btn-sm" data-original-title="Add Commission % to doctors"><i class="fas fa-plus-square"></i> Individual Commission </a>

        </div>
        <div class="card-tools col-md-4">
            <form method="GET">
                <div class="input-group input-group-sm">
                  
                  
                    <select class="form-control m-1" name="consultation_type" id="consultation_type">

                        <option value="">Search By Commission Type </option>
                        <option value="1" <?php if(isset($_GET['consultation_type']) && $_GET['consultation_type'] == 1): ?> selected <?php endif; ?>>Global</option>
                        <option value="4" <?php if(isset($_GET['consultation_type']) && $_GET['consultation_type'] ==  2): ?> selected <?php endif; ?>>Individual</option>

                    </select>



                    <div class="input-group-append">
                        <button class="btn btn-primary" id="search"><i class="fa fa-search" aria-hidden="true"></i></button>

                    </div>
                </div>
            </form>

        </div>

        
    </div>
 


    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Doctor Name</th>
                        <th>Commission Type</th>
                        <th data-orderable="false" >Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php $__currentLoopData = $data; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$value): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>

              
                        <td>
                           
                                <?php echo e($key+1); ?>

                           
                        </td>
                        <td><?php echo e($value->name); ?></td>
                        <?php if($value->consultation_type != 4): ?>

                        <td><span class="badge badge-pill badge-primary">Global</span></td>
                        <?php else: ?>
                        <td><span class="badge badge-pill badge-warning">Individual</span></td>
                        <?php endif; ?>
                        <td>


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="<?php echo e(URL::to('admin/commission/edit')); ?>/<?php echo e($value->id); ?>"> <i class="fas fa-edit"></i></a>

   




                        </td>
                      
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>


                </tbody>



            </table>

        </div>
    </div>



</div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $('#search').click(function(e) {
        e.preventDefault();
        var consultation_type = $('#consultation_type').val();

        $.ajax({
            url: "<?php echo e(route('admin.commission')); ?>",
            type: 'GET',
            data: {
               
                consultation_type: consultation_type,
            },
            success: function(data) {
                location.replace('?consultation_type=' + consultation_type);

            }
        });


    });
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\doctorapp\resources\views/admin/commission/index.blade.php ENDPATH**/ ?>