<!-- Main Sidebar Container -->
<aside class="main-sidebar sidebar-dark-primary elevation-4">
    <!-- Brand Logo -->
    <a href="<?php echo e(route('home')); ?>" class="brand-link">
        
        <img src="<?php echo e(!empty(getSetting('logo')) ? asset('Images/logo/' . getSetting('logo')) : 'logo'); ?>"
            alt="<?php echo e(env('APP_NAME')); ?>" class="brand-image" style="opacity: .8">
        
    </a>

    <!-- Sidebar -->
    <div class="sidebar">
        <!-- Sidebar user panel (optional) -->
        <div class="user-panel mt-3 pb-3 mb-3 d-flex">
            <div class="image">
                
                <img src="<?php echo e(asset('Images/logo/' . getSetting('logo'))); ?>" class="img-circle elevation-2"
                    alt="User Image">

            </div>
            <div class="info">
                <a href="<?php echo e(route('admin.profile')); ?>"
                    class="d-block"><?php echo e(Auth::guard('siteAdmin')->user()->name); ?></a>
            </div>
        </div>

        <!-- Sidebar Menu -->
        <nav class="mt-2">
            <ul class="nav nav-pills nav-sidebar flex-column" data-widget="treeview" role="menu" data-accordion="false">
                <!-- Add icons to the links using the .nav-icon class
               with font-awesome or any other icon font library -->
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.dashboard')); ?>"
                        class="nav-link <?php echo e(Request::is('admin/dashboard') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-tachometer-alt"></i>
                        <p>
                            Dashboard
                        </p>
                    </a>
                </li>

                
                <li class="nav-item">
                    <a href="" class="nav-link <?php echo e(Request::is('admin/users/2*') ? 'active' : ''); ?>">
                        
                        <i class="nav-icon fas fa-user-md" aria-hidden="true"></i>
                        <p>
                            Manage Doctor
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="<?php echo e(route('admin.users', 1)); ?>"
                        class="nav-link <?php echo e(Request::is('admin/users/1*') ? 'active' : ''); ?>">
                        <i class="nav-icon fa fa-male" aria-hidden="true"></i>
                        <p>
                            Manage Patient
                        </p>
                    </a>
                </li>
                
                <li class="nav-item">
                    <a href="<?php echo e(route('admin.service.index')); ?>" class="nav-link <?php echo e(Request::is('admin/service*') ? 'active' : ''); ?>">
                        <i class="nav-icon fa fa-list-alt" aria-hidden="true"></i>
                        <p>
                            Manage Speciality
                        </p>
                    </a>
                </li>

                
                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/subscription*') ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-file-alt" aria-hidden="true"></i>
                        <p>
                            Manage Route
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/subscription*') ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-file-alt" aria-hidden="true"></i>
                        <p>
                            Manage QuickVisit
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/subscription*') ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-file-alt" aria-hidden="true"></i>
                        <p>
                            Manage FAQ
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/subscription*') ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-file-alt" aria-hidden="true"></i>
                        <p>
                            Manage Terms & Conditions
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/subscription*') ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-file-alt" aria-hidden="true"></i>
                        <p>
                            Manage Privacy Policy
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/subscription*') ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-file-alt" aria-hidden="true"></i>
                        <p>
                            Manage Contact
                        </p>
                    </a>
                </li>

                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/subscription*') ? 'active' : ''); ?>">
                        <i class="nav-icon far fa-file-alt" aria-hidden="true"></i>
                        <p>
                            Manage Contact Info
                        </p>
                    </a>
                </li>

                

                
                
                
                

                

                

                
                

                <li class="nav-item">
                    <a href="#" class="nav-link <?php echo e(Request::is('admin/report*') ? 'active' : ''); ?>">
                        <i class="nav-icon fa fa-file" aria-hidden="true"></i>
                        <p>
                            Report
                        </p>
                    </a>
                </li>

                
                <li class="nav-item has-treeview <?php echo e(Request::is('admin/change-password') || Request::is('admin/manage-profile') ? 'menu-open' : ''); ?>">
                    <i class=""></i>
                    <a href="#"
                        class="nav-link <?php echo e(Request::is('admin/change-password') || Request::is('admin/manage-profile') ? 'active' : ''); ?>">
                        <i class="nav-icon fas fa-cog"></i>
                        <p>
                            Settings
                            <i class="fas fa-angle-left right"></i>
                            <!--  <span class="badge badge-info right">6</span> -->
                        </p>
                    </a>
                    <ul class="nav nav-treeview">
                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.change.password')); ?>"
                                class="nav-link <?php echo e(Request::is('admin/change-password') ? 'active' : ''); ?>">
                                <i class="fas fa-key nav-icon"></i>
                                <p>Change Password</p>
                            </a>
                        </li>

                        <li class="nav-item">
                            <a href="<?php echo e(route('admin.manageProfile')); ?>"
                                class="nav-link <?php echo e(Request::is('admin/manage-profile') ? 'active' : ''); ?>">
                                <i class="fas fa-user  nav-icon"></i>
                                <p>Manage Profile</p>
                            </a>
                        </li>

                        

                    </ul>
                </li>



            </ul>
        </nav>
        <!-- /.sidebar-menu -->
    </div>
    <!-- /.sidebar -->
</aside>
<?php /**PATH C:\xampp\htdocs\doctorappadmin\resources\views/admin/common/menu.blade.php ENDPATH**/ ?>