

<?php $__env->startSection('title', 'Patient Details'); ?>

<?php $__env->startSection('body'); ?>

<?php $__env->startSection('header', 'Patient Details'); ?>
<?php $__env->startSection('badge'); ?>

<li class="breadcrumb-item"><a href="<?php echo e(route('admin.patient')); ?>">Patient Details</a></li>
<?php $__env->stopSection(); ?>


<div class="card">

    <div class="card-body">

        <a class="btn btn-sm btn-outline-success" style="text-align:right" data-toggle="tooltip" title="Click to see earlier consultation record" href="<?php echo e(URL::to('admin/patient/appointment_list')); ?>/<?php echo e($patient->id); ?>"> Appointment List</a>



        <div class="card-body">

            <div class="form-group row">
                <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Profile Image:</span><br>

                    <?php if($patient->profile_image !== ''): ?>
                    <a href="<?php echo e($patient->profile_image); ?>" target="_blank"> <img src="<?php echo e(asset($patient->profile_image)); ?>" class="img-circle img-fluid" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                    <?php else: ?>
                    <a href="#" target="_blank"> <img src="<?php echo e(asset('images/noimage.png')); ?>" class="img-circle img-fluid" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                    <?php endif; ?>
                </p>
            </div>

            <div class="form-group row">
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Name:</span>
                    <?php echo e($patient->name); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Email:</span>
                    <?php echo e($patient->email); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Phone:</span>
                    <?php echo e($patient->phone); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Gender:</span>
                    <?php echo e($patient->sex); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Address:</span>
                    <?php echo e($patient->address); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Date of Birth:</span>
                    <?php echo e($patient->dob); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Height:</span>
                    <?php echo e($patient->height); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Weight:</span>
                    <?php echo e($patient->weight); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Blood Group:</span>
                    <?php echo e($patient->blood_gr); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Blood Sugar Level:</span>
                    <?php echo e($patient->blood_suger_level); ?>


                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Allergy:</span>
                    <span>
                        <?php $__currentLoopData = patient_allergy($patient->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row->allergy); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Medical History:</span>
                    <span>
                        <?php $__currentLoopData = patient_medical($patient->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row->medical); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Surgical History:</span>
                    <span>
                        <?php $__currentLoopData = patient_surgery($patient->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row->surgery); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Surgical Results:</span>
                    <span>
                        <?php
                        if ($patient->surgical_images != '') {
//$str = substr($patient->surgical_images, 0, -1);

                            $s_results = explode(',', $patient->surgical_images);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }

                        ?>

                        <?php if($count == 0): ?>

                        <?php else: ?>
                        <?php $__currentLoopData = $s_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $ext = explode('.', $row);

                        ?>
                        <?php if($ext[3] == 'pdf'): ?>
                        <a href="<?php echo e($row); ?>" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        <?php else: ?>
                        <a href="<?php echo e($row); ?>" target="_blank"><img src="<?php echo e($row); ?>" style="height:50px;width:50px;" /></a>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </span>
                </p>
                <p class="col-md-2 form-control-label" for="name"><span style="font-weight:600;">Social History</span><br>
                    <span>
                        <?php $__currentLoopData = patient_social_history($patient->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row->social_history); ?><br>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                    </span>

                </p>
                <p class="col-md-2 form-control-label" for="name"><span style="font-weight:600;">Type</span><br>
                    <span>
                        <?php
                        $s_type = explode(',', $patient->social_history_type);

                        ?>
                        <?php $__currentLoopData = $s_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row); ?><br>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </span>
                </p>
                <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Frequency</span><br>
                    <span>
                        <?php
                        $s_type = explode(',', $patient->frequency);

                        ?>
                        <?php $__currentLoopData = $s_type; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row); ?><br>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </span>
                </p>


                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Medication History:</span>
                    <span>
                        <?php $__currentLoopData = patient_medication($patient->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row->title); ?>(<?php echo e($row->unit); ?>),
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name">
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Lab History:</span>
                    <span>
                        <?php $__currentLoopData = patient_lab($patient->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php echo e($row->lab); ?>,
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Lab Results:</span>
                    <span>
                        <?php
                        if ($patient->lab_result_images != '') {
                           // $str = substr($patient->lab_result_images, 0, -1);
                            $lab_results = explode(',', $patient->lab_result_images);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }

                        ?>
                        <?php if($count==0): ?>

                        <?php else: ?>
                        <?php $__currentLoopData = $lab_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $ext = explode('.', $row);

                        ?>
                        <?php if($ext[3]==='pdf'): ?>
                        <a href="<?php echo e($row); ?>" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        <?php else: ?>

                        <a href="<?php echo e($row); ?>" target="_blank"><img src="<?php echo e($row); ?>" style="height:50px;width:50px;" /></a>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>

                    </span>

                </p>
                <?php if($patient->color !=''): ?>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Health Condition:</span>
                    <span style="color:<?php echo e($patient->color); ?>;font-weight:600"><?php echo e($patient->type); ?>(<?php echo e($patient->color); ?>)</span>
                </p>
                <?php endif; ?>
            </div>

        </div>

    </div>
    <div class="card-footer">
        <div class="col text-right">
            <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>


        </div>
    </div>

</div>
<!-- /.card-body -->

<!-- /.card-footer-->
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\doctorapp\resources\views/admin/user/patient_view.blade.php ENDPATH**/ ?>