

<?php $__env->startSection('title', 'Doctor Details'); ?>

<?php $__env->startSection('body'); ?>

<?php $__env->startSection('header', 'Doctor Details'); ?>
<?php $__env->startSection('badge'); ?>

<li class="breadcrumb-item"><a href="<?php echo e(route('admin.appropved_doctors')); ?>">Doctor Details</a></li>
<?php $__env->stopSection(); ?>


<div class="card">

    <div class="card-body">
        <form role="form" method="POST" action="<?php echo e(route('admin.route.store')); ?>" enctype="multipart/form-data" id="cmsForm">
            <?php echo e(csrf_field()); ?>



            <div class="card-body">

                <div class="form-group row">
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Profile Image:</span><br>
                        <?php if($doctor->profile_image!=''): ?>
                        <a href="<?php echo e(asset($doctor->profile_image)); ?>" target="_blank"> <img src="<?php echo e(asset($doctor->profile_image)); ?>" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        <?php else: ?>
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        <?php endif; ?>
                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Doctor Id:</span>
                        DOC00<?php echo e($doctor->id); ?>


                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Name:</span>
                        <?php echo e($doctor->name); ?>


                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Email:</span>
                        <?php echo e($doctor->email); ?>


                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Phone:</span>
                        +1 <?php echo e($doctor->phone); ?>


                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Gender:</span>
                        <?php echo e($doctor->sex); ?>


                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Address:</span>
                        <?php echo e($doctor->address); ?>


                    </p>
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Skill Set / Specialization:</span>
                        <?php echo e(doctors_speciality_m($doctor->id)); ?>



                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">DEA:</span>
                        <?php echo e($doctor->dea); ?>

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">License:</span>
                        <?php echo e($doctor->license); ?>

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">NPI:</span>
                        <?php echo e($doctor->npi); ?>

                    </p>
                    <?php
                    $fee = explode(',', $doctor->fee_per_consultation);



                    ?>
                    <?php if($doctor->fee_per_consultation!='' && count($fee)==3): ?>

                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Video consultation fee:</span>
                        <?php echo e($fee[0]); ?>


                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Audio consultation fee:</span>
                        <?php echo e($fee[1]); ?>


                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Chat consultation fee:</span>
                        <?php echo e($fee[2]); ?>


                    </p>
                    <?php endif; ?>

                    <p class="col-md-3 form-control-label" for="name"><span style="font-weight:600;">Practitional License:</span><br>
                        <?php if($doctor->certificate_practice!=''): ?>
                        <?php
                        $exp = explode('.', $doctor->certificate_practice);
                      

                        ?>
                        <?php if($exp[3]=='pdf'): ?>
                        <a href="<?php echo e(asset($doctor->certificate_practice)); ?>" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        <?php else: ?>
                        <a href="<?php echo e(asset($doctor->certificate_practice)); ?>" target="_blank"> <img src="<?php echo e(asset($doctor->certificate_practice)); ?>" style="height:100px;width:100px" title="Profile image" alt=""></a>
                        <?php endif; ?>
                        <?php else: ?>
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt=""></a>
                        <?php endif; ?>
                    </p>

                    <p class="col-md-7 form-control-label" for="name"><span style="font-weight:600;">Registration No of Practitional License:</span>
                        <?php echo e($doctor->reg_no_p); ?>


                    </p>
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">About:</span>
                        <?php echo e($doctor->about); ?>


                    </p>


                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;"><span style="font-weight:600;">Qualification</span><br>
                        <?php
                        if ($doctor->certificate_name != '') {

                            $s_results = explode(',', $doctor->certificate_name);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        <?php if($count==0): ?>

                        <?php else: ?>
                        <?php $__currentLoopData = $s_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span style="padding:20px;"> <?php echo e($row); ?> </span>
                        <br><br><br>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>



                    </p>
                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;" for="name"><span style="font-weight:600;">Certificates</span><br>
                        <?php
                        if ($doctor->certificate_mbbs != '') {
                            // $str = substr($doctor->certificate_mbbs, 0, -1);
                            $s_results = explode(',', $doctor->certificate_mbbs);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        <?php if($count==0): ?>

                        <?php else: ?>
                        <?php $__currentLoopData = $s_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <?php
                        $ext = explode('.', $row);
                  
                       
                        ?>
                        <?php if($ext[3] === "pdf"): ?>
                        <a href="<?php echo e($row); ?>" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        <br><br>
                        <?php else: ?>
                        <a href="<?php echo e($row); ?>" target="_blank"><img src="<?php echo e($row); ?>" style="height:50px;width:50px;" /></a>
                        <br><br>
                        <?php endif; ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>


                    </p>

                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;" for="name"><span style="font-weight:600;">Registration No</span><br>
                        <?php
                        if ($doctor->registration_no != '') {

                            $s_results = explode(',', $doctor->registration_no);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }
                        ?>
                        <?php if($count==0): ?>

                        <?php else: ?>
                        <?php $__currentLoopData = $s_results; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <span style="padding:20px;"> <?php echo e($row); ?> </span>
                        <br><br><br>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>



                    </p>
                    <?php if(count(avl_doc($doctor->id))>0): ?>
                    <p class="col-md-12 form-control-label"><span style="font-weight:600;"><u>Availability:</u>
                            (&#128992;Booked
                            &#128994;Available)
                        </span>
                    <table class="table">
                        <thead>
                            <tr>
                                <th scope="col" width="5%">No</th>
                                <th scope="col" width="10%">Date</th>
                                <th scope="col" width="20%">Time Duration</th>
                                <th scope="col" width="20%">Slot Duration</th>
                                <th scope="col" width="10%">Patient</th>
                                <th scope="col" width="15%">Consultation Type</th>
                          

                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = avl_doc($doctor->id); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                            <tr>
                                <th><?php echo e($key+1); ?></th>
                                <td><?php echo e($row->day); ?>,<?php echo e(date( 'm/d/Y', strtotime($row->date))); ?> (<?php echo e($row->type); ?>)</td>
                                <td><?php echo e(date( 'H:i', strtotime($row->start_time))); ?> to <?php echo e(date( 'H:i', strtotime($row->end_time))); ?></td>
                                <?php
                                $id = $row->id;
                                $duration = time_slot($row->type);  // split by 30 mins
                                $u_id = $row->user_id;

                                ?>
                                <td id="slot_<?php echo e($row->id); ?>" style="display:none;">
                                    <?php
                                    $slots = getTimeSlot($duration, $row->start_time, $row->end_time);

                                    foreach ($slots  as $row1) {

                                        $date =  date('Y/m/d/', strtotime($row->date));
                                        $t = getBookingDtl($u_id, $row1['slot_start_time'], $row1['slot_end_time'], $date);

                                        $newTime = date('H:i', strtotime($row1['slot_end_time']) - (1 * 60));
                                        if ($t !== 0) {
                                            echo '<span  style="color:#DC582A">' . $t . '</span><br>';
                                        } else {
                                            echo '<span  style="color:green">' . $row1['slot_start_time'] . ' to ' . $newTime . '</span><br>';
                                        }
                                    }



                                    ?>

                                    <a href="#" data-toggle="tooltip" title="Click to hide time slots" onClick="rmv_slot(<?php echo e($id); ?>)"><i class="fas fa-remove"></i></a>

                                </td>

                                <td id="slot_t_<?php echo e($id); ?>">

                                    <a href="#" data-toggle="tooltip" title="Click to view time slots" onClick="ckh_slot(<?php echo e($id); ?>)"><i class="fas fa-eye"></i></a>


                                </td>
                                <td id="slot_d_<?php echo e($id); ?>"></td>
                                <td id="slot_d1_<?php echo e($id); ?>"></td>
                                <td id="slot_d2_<?php echo e($id); ?>"></td>

                                <td id="slot_p_<?php echo e($id); ?>" style="display:none">
                                    <?php
                                    $slots = getTimeSlot($duration, $row->start_time, $row->end_time);

                                    foreach ($slots  as $row1) {
                                        $date =  date('Y/m/d/', strtotime($row->date));
                                        $t = getBookingDtlP($u_id, $row1['slot_start_time'], $row1['slot_end_time'], $date);
                                        if ($t !== 0) {
                                            echo  $t . '<br>';
                                        } else {
                                            echo  'NA<br>';
                                        }
                                    }



                                    ?>


                                </td>

                                <td id="slot_p1_<?php echo e($id); ?>" style="display:none">
                                    <?php
                                    $slots = getTimeSlot($duration, $row->start_time, $row->end_time);

                                    foreach ($slots  as $row1) {
                                        $date =  date('Y/m/d/', strtotime($row->date));
                                        $t = getBookingDtlT($u_id, $row1['slot_start_time'], $row1['slot_end_time'], $date);
                                        if ($t !== 0) {
                                            echo  $t . '<br>';
                                        } else {
                                            echo  'NA<br>';
                                        }
                                    }



                                    ?>


                                </td>

                          
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                    </p>
                    <?php endif; ?>


                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="<?php echo e(url()->previous()); ?>" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>


                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script>
    function ckh_slot(id) {
        $('#slot_' + id).show();
        $('#slot_t_' + id).hide();
        $('#slot_p_' + id).show();
        $('#slot_p1_' + id).show();
        $('#slot_p2_' + id).show();
        $('#slot_d_' + id).hide();
        $('#slot_d1_' + id).hide();
        $('#slot_d2_' + id).hide();

    }

    function rmv_slot(id) {
        $('#slot_' + id).hide();
        $('#slot_t_' + id).show();
        $('#slot_p_' + id).hide();
        $('#slot_p1_' + id).hide();
        $('#slot_p2_' + id).hide();
        $('#slot_d_' + id).show();
        $('#slot_d1_' + id).show();
        $('#slot_d2_' + id).show();
    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorapp\resources\views/admin/user/doctor_view_approved.blade.php ENDPATH**/ ?>