

<?php $__env->startSection('title', 'Manage Profile'); ?>

<?php $__env->startSection('body'); ?>
<?php $__env->startSection('header', 'Manage Profile'); ?>
<?php $__env->startSection('badge'); ?>

<li class="breadcrumb-item"><a href="<?php echo e(route('admin.manageProfile')); ?>">Manage Profile</a></li><br>

<?php $__env->stopSection(); ?>
<div class="text-right">
    <?php if(request()->user()->profile_image != ''): ?>
    <img src="../<?php echo e(request()->user()->profile_image); ?>" height="128px" width="128px" alt="logo" style="padding-right:10px;" class="img-circle img-fluid">
    <?php else: ?>
    <img src="../images/noimage.png" height="80px" width="90px" alt="logo" style="padding-right:25px;">
    <?php endif; ?>

</div>
<section class="content">
    <?php if(session('error')): ?>
    <div class="alert alert-danger">
        <?php echo e(session('error')); ?>

    </div>
    <?php endif; ?>
    <?php if(session('success')): ?>
    <div class="alert alert-success">
        <?php echo e(session('success')); ?>

    </div>
    <?php endif; ?>
    <div class="container-fluid">
        <!-- SELECT2 EXAMPLE -->
        <div class="card card-default">
            <div class="card-header">
                <h3 class="card-title">Manage Profile</h3>

                <div class="card-tools">
                    <button type="button" class="btn btn-tool" data-card-widget="collapse"><i class="fas fa-minus"></i></button>


                </div>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
                <form role="form" method="POST" action="<?php echo e(route('admin.manageProfile')); ?>" enctype="multipart/form-data">
                    <?php echo e(csrf_field()); ?>

                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Name <span style="color:red">*</span></label>


                                <input id="name" type="text" class="form-control" name="name" value="<?php echo e(request()->user()->name); ?>" required>

                            </div>
                        </div>

                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Email</label>
                                <input id="email" type="email" class="form-control" name="email" value="<?php echo e(request()->user()->email); ?>" disabled>

                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group row">
                                <label class="col-md-12 form-control-label">Phone <span style="color:red">*</span></label>
                                <div class="col-md-2">

                                    <input type="hidden" name="country_code" class="form-control fil" id="country_code" value="<?php echo e(request()->user()->country); ?>" placeholder="phone" autocomplete="off">
                                    <input type="hidden" name="dial_code" class="form-control fil" id="dial_code" value="<?php echo e(request()->user()->code); ?>" placeholder="phone" autocomplete="off">
                                    <input type="tel" name="code" class="form-control fil" id="code" autocomplete="off">
                                </div>

                                <div class="col-md-10">


                                    <input id="phone" type="text" class="form-control" name="phone" maxlength="10" pattern="\d{10}" value="<?php echo e(request()->user()->phone); ?>" required>
                                </div>
                            </div>
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label>Address <span style="color:red">*</span></label>


                                <input id="address" type="text" class="form-control" name="address" id="address" value="<?php echo e(request()->user()->address); ?>" required>

                            </div>
                        </div>
                        <div class="form-group row col-md-12">
                            <label class="col-md-2 form-control-label" for="name">Admin Profile Image</label>
                            <div class="col-md-9 custom-file">
                                <input type="file" class="custom-file-input" name="logo" id="inputGroupFile01">
                                <?php if(request()->user()->profile_image!=''): ?>
                                <label class="custom-file-label" for="inputGroupFile01"><?= request()->user()->profile_image ?></label>
                                <?php else: ?>
                                <label class="custom-file-label" for="inputGroupFile01">Choose Image</label>
                                <?php endif; ?>
                            </div>
                        </div>
                           
                            <div class="col-md-12">

                                <?php if(request()->user()->profile_image != ''): ?>
                                <img src="../<?php echo e(request()->user()->profile_image); ?>" height="128px" width="128px" alt="logo" style="margin-top:-20px;" class="img-circle img-fluid">
                                <?php else: ?>
                                <img src="../images/noimage.png" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                                <?php endif; ?>
                            </div>

                           <div class="form-group row col-md-12"  style="padding-top:5px;">
                            <label class="col-md-2 form-control-label" for="name">App Logo</label>
                            <div class="col-md-9 custom-file1">
                                <input type="file" class="custom-file-input1" name="logo_w" id="inputGroupFile02">
                                <?php if(getSetting('logo')!=''): ?>
                                <label class="custom-file-label" for="inputGroupFile02">Images/logo/<?= getSetting('logo') ?></label>
                                <?php else: ?>
                                <label class="custom-file-label" for="inputGroupFile02">Choose Image</label>
                                <?php endif; ?>
                            </div>
 



                               
                            </div>

                            <div class="col-md-12">




                                <?php if(getSetting('logo') != ''): ?>
                                <img src="<?php echo e(asset('Images/logo/' . getSetting('logo'))); ?>" height="128px" width="128px" style="margin-top:-20px;" class="img-circle img-fluid" alt="User Image">
                                <?php else: ?>
                                <img src="../images/noimage.png" height="128px" width="128px" alt="logo" class="img-circle img-fluid">
                                <?php endif; ?>
                            </div>
<br><br>
                            <button type="submit" class="btn btn-primary" style="padding-top:10px;">
                                Save
                            </button>
                            &nbsp;&nbsp;
                            <a class="btn btn-warning" style="padding-top:10px;" href="<?php echo e(route('admin.change.password')); ?>">
                                Change Password
                            </a>
                        </div>

                    </div>
                </form>
            </div>

        </div>

    </div>
</section>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.js"></script>
<script>
$(document).ready(function(){
  $('#inputGroupFile01').on('change',function(){
      //get the file name
      var fileName = $(this).val();
      //replace the "Choose a file" label
      $(this).next('.custom-file-label').html(fileName);
  })
})

</script>
<script>
$(document).ready(function(){
  $('#inputGroupFile02').on('change',function(){
      //get the file name
      var fileName = $(this).val();
      //replace the "Choose a file" label
      $(this).next('.custom-file-label1').html(fileName);
  })
})

</script>
<script>
    var code = $('#country_code').val();

    var input = document.querySelector("#code");
    var iti = window.intlTelInput(input, {
        formatOnDisplay: true,
        initialCountry: code,
        autoPlaceholder: "off",
        separateDialCode: true,
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js",
    });
    input.addEventListener("countrychange", function() {
        console.log(iti.getSelectedCountryData());

        $('#country_code').val(iti.getSelectedCountryData().iso2);
        $('#dial_code').val(iti.getSelectedCountryData().dialCode);

    });
</script>
<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=AIzaSyCyJ7Lirxe2ObjpsZbKTgeafLSA9bYSA0M&libraries=places"></script>
<script>
    $(document).ready(function() {
        $("#latitudeArea").addClass("d-none");
        $("#longtitudeArea").addClass("d-none");
    });
</script>

<script>
    google.maps.event.addDomListener(window, 'load', initialize);

    function initialize() {
        var input = document.getElementById('address');
        var autocomplete = new google.maps.places.Autocomplete(input);

        autocomplete.addListener('place_changed', function() {
            var place = autocomplete.getPlace();
            $('#latitude').val(place.geometry['location'].lat());
            $('#longitude').val(place.geometry['location'].lng());

            $("#latitudeArea").removeClass("d-none");
            $("#longtitudeArea").removeClass("d-none");
        });
    }
</script>




<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\doctorapp\resources\views/admin/auth/manage_profile.blade.php ENDPATH**/ ?>