

<?php $__env->startSection('title', 'Unapproved Doctors'); ?>

<?php $__env->startSection('body'); ?>
<?php $__env->startSection('header', 'Manage Unapproved Doctors'); ?>
<?php $__env->startSection('badge'); ?>

<?php $__env->stopSection(); ?>

<?php if(Session::has('message')): ?>
<div class="alert alert-success">
    <?php echo e(Session::get('message')); ?>


</div>
<?php endif; ?>

<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">Unapproved Doctors</h3>
    </div>





    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Speciality</th>
                        <th>Status</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                <?php
                    $i = 1;
                    ?>
                    <?php $__currentLoopData = $unappropved_doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$u_d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>

                        <td>


                            <?php echo e($i++); ?>


                        </td>
                        <td><?php echo e($u_d->name); ?></td>
                        <td><?php echo e($u_d->email); ?></td>

                        <td>
                            <?php echo e(doctors_speciality($u_d->id)); ?>



                        </td>
                        <?php if($u_d->status == 1): ?>
                        <td><span class="badge bg-warning">Not verified</span></td>
                        <?php elseif($u_d->status == 3): ?>
                        <td><span class="badge bg-danger">Disapproved</span></td>
                        <?php elseif($u_d->status == 4): ?>
                        <td><span class="badge bg-info">Blocked</span></td>
                        <?php else: ?>
                        <td><span class="badge bg-secondary">OTP not verified</span></td>
                        <?php endif; ?>
                        <td>


                            <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to view" href="<?php echo e(URL::to('admin/doctor/view')); ?>/<?php echo e($u_d->id); ?>"> <i class="fas fa-eye"></i></a>




                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="<?php echo e(URL::to('admin/doctor/edit')); ?>/<?php echo e($u_d->id); ?>"> <i class="fas fa-edit"></i></a>




                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>



                </tbody>



            </table>

        </div>
    </div>



</div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\doctorapp\resources\views/admin/user/unapproved.blade.php ENDPATH**/ ?>