

<?php $__env->startSection('title', 'Manage Appointments'); ?>

<?php $__env->startSection('body'); ?>
<?php $__env->startSection('header', 'Manage Appointments'); ?>
<?php $__env->startSection('badge'); ?>

<?php $__env->stopSection(); ?>



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">Appointments</h3>
    </div>
    <?php if(Session::has('message')): ?>
    <div class="alert alert-danger">
        <?php echo e(Session::get('message')); ?> 
    </div>
    <?php endif; ?>
    <div class="row">


        <div class="card-tools col-md-10">
            <form method="GET">
                <div class="input-group input-group-sm">
                    <input type="date" name="from_date" id="from_date" class="form-control m-1"   max="2050-12-31" <?php if(isset($_GET['from_date'])): ?> value="<?php echo $_GET['from_date']?>" <?php endif; ?> required>
                    to
                    <input type="date" name="to_date" id="to_date" class="form-control m-1" max="2050-12-31" <?php if(isset($_GET['to_date'])): ?> value="<?php echo $_GET['to_date']?>" <?php endif; ?> required>
                    <select class="form-control m-1" name="spl_id" id="spl_id">

                        <option value="">Select Specialization</option>
                        <?php $__currentLoopData = $services; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($s->id); ?>" <?php if(isset($_GET['spl_id']) && $_GET['spl_id'] == $s->id): ?> selected <?php endif; ?>><?php echo e($s->name); ?></option>

                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                    <select class="form-control m-1" name="con_type" id="con_type">

                        <option value="">Select Consultation </option>
                        <option value="Video" <?php if(isset($_GET['con_type']) && $_GET['con_type'] == 'Video'): ?> selected <?php endif; ?>>Video</option>
                        <option value="Audio" <?php if(isset($_GET['con_type']) && $_GET['con_type'] == 'Audio'): ?> selected <?php endif; ?>>Audio</option>
                        <option value="Chat" <?php if(isset($_GET['con_type']) && $_GET['con_type'] == 'Cha t'): ?> selected <?php endif; ?>>Chat</option>
                    </select>



                    <div class="input-group-append">
                        <button class="btn btn-primary" id="search"><i class="fa fa-search" aria-hidden="true"></i></button>

                    </div>
                </div>
            </form>

        </div>

    </div>

<br>

    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>DateTime (mm-dd-yyyy) </th>
                        <th>Doctor</th>
                        <th>Patient</th>
                        <th>Specialization</th>
                  
                        <th>Consultation Type</th>
                        <th>Payment Status</th>
                        <th>Prescription Status</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i=1;
                ?>
                    <?php $__currentLoopData = $appointments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$u_d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>

                        <td>


                           <?php echo e($i++); ?>


                        </td>
                        <td><?php echo e(date("m-d-Y",strtotime($u_d->date))); ?> (<?php echo e(date("h:i a",strtotime($u_d->slot_start))); ?> to <?php echo e(date("h:i a",strtotime($u_d->slot_end))); ?>)</td>
                        <td><?php echo e($u_d->doctor->name); ?></td>
                        <td><?php echo e($u_d->patient->name); ?></td>
                        <td><?php echo e($u_d->specialization->name); ?></td>
                        <td><?php echo e($u_d->consultation_type); ?></td>

                        <?php if($u_d->payment_status == 1): ?>
                        <td><span class="badge bg-success" style="padding:5px;color:white;">Success</span></td>
                        <?php elseif($u_d->payment_status == 2): ?>
                        <td><span class="badge bg-danger" style="padding:5px;color:white;" >Failed</span></td>
                        <?php else: ?>
                        <td><span class="badge bg-warning" style="padding:5px;color:white;">Pending</span></td>
                        <?php endif; ?>


                        <?php if($u_d->status == 1): ?>
                        <td><span class="badge bg-warning" style="padding:5px;color:white;">Pending</span></td>
                        <?php elseif($u_d->status == 2): ?>
                        <td><span class="badge bg-success" style="padding:5px;color:white;" >Accepted</span></td>
                        <?php else: ?>
                        <td><span class="badge bg-danger" style="padding:5px;color:white;">Cancelled</span></td>
                        <?php endif; ?>
                        <td>
                            <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to view" href="<?php echo e(URL::to('admin/appointment/view')); ?>/<?php echo e($u_d->id); ?>"> <i class="fas fa-eye"></i></a>


                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>





                </tbody>



            </table>

        </div>
    </div>



</div>



<?php $__env->stopSection(); ?>
<?php $__env->startPush('scripts'); ?>
<script>
    $('#search').click(function(e) {
        e.preventDefault();
        var from_date = $('#from_date').val();
        var to_date = $('#to_date').val();
        var spl_id = $('#spl_id').val();
        var con_type = $('#con_type').val();

        $.ajax({
            url: "<?php echo e(route('admin.appointment')); ?>",
            type: 'GET',
            data: {
                from_date: from_date,
                to_date: to_date,
                spl_id: spl_id,
                con_type: con_type
            },
            success: function(data) {
                location.replace('?from_date=' + from_date + '&' + 'to_date=' + to_date + '&spl_id=' + spl_id + '&con_type=' + con_type);

            }
        });


    });
</script>

<?php $__env->stopPush(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\doctorapp\resources\views/admin/appoinment/index.blade.php ENDPATH**/ ?>