<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

    <title>Doctor App</title>
</head>

<body>


    <div class="container">
        <div class="justify-content-center row">
            <div>
                <div class="col-md-12" style="background-color:#a2bba3;padding-top:9px;padding-bottom:9px;">
                    <div style="font-size:15px;background-color:#f6c3cb;padding:5px;border:2px solid black;margin-top:10px;margin-bottom:10px;">
                        <div class="row">
                            <div class="col-md-12">
                                <h6>DEA: #<?php echo e($dea); ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;License: #<?php echo e($license); ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;NPI: #<?php echo e($npi); ?></h6>
                                <!-- <h4 class="text-uppercase text-center"><img src="https://nodeserver.mydevfactory.com/jajakul/Prescription/logo.png" style="height:100px;width:100px;"></h4><br> -->
                                <h4 class="text-uppercase text-center">PRESCRIPTION</h4><br>
                                <div class=""><span class="font-weight-bold text-uppercase">Prescription no:</span><span class="ml-1">D00<?php echo e($doc_id); ?>A<?php echo e($number); ?></span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="font-weight-bold text-uppercase">Date:</span><span class="ml-1"><?php echo e($date); ?></span></div>


                            </div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-md-12">
                                <p> Name :<?php echo e($patient); ?> &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;DOB : <?php echo e($dob); ?>&nbsp;&nbsp;&nbsp;&nbsp;Sex : <?php echo e($sex); ?></p>
                                <p> Address:<?php echo e($address); ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Age : <?php echo e($age); ?></p>
                                <p> Height:<?php echo e($height); ?>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Weight : <?php echo e($weight); ?></p>
                                <p class="text-uppercase text-left"><img src="https://nodeserver.mydevfactory.com/jajakul/Prescription/rx.png" style="height:60px;width:60px;"></p>
                            </div>

                        </div>


                        <div class="table-responsive">
                            <!-- <h4 style="color:#294876">Medicine Details</h4> -->
                            <table class="table" style="border:1px solid black">
                                <thead style="background-color:#a2bba3">
                                    <tr>


                                        <th>Drug</th>
                                        <th>Dose</th>
                                        <th>Frequency</th>
                                        <th>Route</th>
                                        <th>Duration</th>
                                        <th>Remarks</th>

                                    </tr>
                                </thead>

                                <tbody>
                                    <?php $__currentLoopData = $med; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td style="border:1px solid black"><?php echo e($row->medicine); ?></td>
                                        <td style="border:1px solid black"><?php echo e($row->dose); ?></td>
                                        <td style="border:1px solid black"><?php echo e($row->frequency); ?></td>
                                        <td style="border:1px solid black"><?php echo e($row->route_name); ?></td>
                                        <td style="border:1px solid black"><?php echo e($row->course); ?> Days</td>
                                        <td style="border:1px solid black"><?php echo e($row->brief); ?></td>
                                    </tr>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </tbody>


                            </table>
                        </div>



                        <div class="row text-center">
                            <div class="col-md-12">


                                <p><u><b>Dr <?php echo e($doctor); ?></b></u></p>
                                <p><u><b>(Signature) </b></u></p>

                                <!-- <p>Doctor Qulification : <?php echo e($specility); ?></p> -->
                            </div>

                        </div>
                        <div class="row">
                            <div class="col-md-12">

                                <p><u><b>Refills : </b></u></p><br>
                                <p><u><b>Dispense as Written</b></u>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<u><b>May Substitute</b></u></p>



                            </div>

                        </div>
                        <!-- <div>
                        <p style="color: #0075c9; margin-bottom: 0px;">Doctor App, Thank You Visit Again</p>
                    </div> -->

                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
</body>

</html><?php /**PATH C:\xampp\htdocs\doctorapp\resources\views/prescription.blade.php ENDPATH**/ ?>