

<?php $__env->startSection('title', 'Manage Commission'); ?>

<?php $__env->startSection('body'); ?>

<?php $__env->startSection('header', 'Manage Commission'); ?>
<?php $__env->startSection('badge'); ?>
<li class="breadcrumb-item"><a href="<?php echo e(route('admin.global.commission')); ?>">Manage Commission</a></li>
<?php $__env->stopSection(); ?>

<?php if(Session::has('message')): ?>
<div class="alert alert-success">
    <?php echo e(Session::get('message')); ?>

</div>
<?php endif; ?>
<?php if($errors->any()): ?>
<?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="alert alert-danger"><?php echo e($error); ?></div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
<?php endif; ?>
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Commission</h3>
    </div>
    <div class="card-body">

        <form role="form" method="POST" action="<?php echo e(route('admin.commission.store')); ?>" enctype="multipart/form-data" id="cmsForm">
            <?php echo e(csrf_field()); ?>


            <input type="hidden" id="id" name="id" value="<?php echo e($data->id); ?>">
            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Doctor<span class="text-danger">*</span></label>

                    <div class="col-md-6">

                        <select class="form-control" name="doctor_id" id="doctor_id" required>
                            <option value="">--Choose a Doctor--</option>
                            <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($row->id); ?>" <?php if($data->id == $row->id): ?> selected <?php endif; ?>><?php echo e($row->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                        </select>

                    </div>
                    <!--col-->
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Type of Commission <span class="text-danger">*</span></label>

                    <div class="col-md-6">

                        <input type="radio" id="type" name="consultation_type" value="1" required onchange="return get_com()" <?php if($data->consultation_type == 1): ?> checked <?php endif; ?>>
                        <label for="huey">Global</label>



                        <input type="radio" id="type" name="consultation_type" value="4" onchange="return get_com()" <?php if($data->consultation_type == 4): ?> checked <?php endif; ?>>
                        <label for="dewey">Individual</label>
                        <br>


                        <span id="msg" style="display:none" class="text-danger">Please set global commission percentage</span>
                    </div>

                    <!--col-->
                </div>

                <?php if($data->consultation_type == 1 ): ?>
                <div class="form-group row" id="per1">
                    <label class="col-md-2 form-control-label" for="name">Percentage (%) <span class="text-danger">*</span></label>

                    <div class="col-md-6">

                        <input type="number" name="per" id="per" value="<?php echo e(g_commission()); ?>" class="form-control" min="1" max="99" required />

                    </div>
                    <!--col-->
                </div>
                <?php else: ?>
                <div class="form-group row" id="per1">
                    <label class="col-md-2 form-control-label" for="name">Percentage (%) <span class="text-danger">*</span></label>

                    <div class="col-md-6">

                        <input type="number" name="per" id="per" value="<?php echo e($data->per_con); ?>" class="form-control" min="1" max="99" required />

                    </div>
                    <!--col-->
                </div>
                <?php endif; ?>



            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="<?php echo e(route('admin.commission')); ?>" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update </button>
                </div>
            </div>
        </form>

    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script>
    function get_com() {

        var type = $("input[name=consultation_type]:checked").val();
        if (type == 1) {
            $.ajax({
                url: "<?php echo e(route('admin.global_per')); ?>",
                type: 'GET',
                success: function(data) {
                    if (data != 0) {
                        $('#per').val(data);

                        $('#per1').hide();
                    } else {
                        $('#msg').show();
                        $(":submit").attr("disabled", true);
                    }



                }
            });
        } else {
            $('#per1').show();
            $('#msg').hide();
            $(":submit").attr("disabled", false);
            $('#per').attr("disabled", false);
            $('#per').val(<?php echo $data->per_con; ?>);
        }

    }
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layout.admin_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH D:\xampp\htdocs\doctorapp\resources\views/admin/commission/edit.blade.php ENDPATH**/ ?>