<!doctype html>
<html lang="en">

<head>
    <!-- Required meta tags -->
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">

    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">

    <title>DOCKTUR</title>
</head>

<body>


    <div class="container">
        <div class="justify-content-center row">
            <div>
                <div class="col-md-12" style="background-color:#a2bba3;padding-top:9px;padding-bottom:9px;">
                    <div style="font-size:15px;background-color:#f6c3cb;padding:5px;border:2px solid black;margin-top:10px;margin-bottom:10px;">
                        <div class="row">
                            <div class="col-md-12">
                                <h6><span class="font-weight-bold text-uppercase">DEA:</span> #{{$dea}}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="font-weight-bold text-uppercase">License:</span> #{{$license}}&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="font-weight-bold text-uppercase">NPI:</span> #{{$npi}}</h6>

                                <div style="margin:0px;text-align:center;"><span class="font-weight-bold text-uppercase" style="font-size:35px;">DOCKTUR</span></div>
                                <div style="margin:0px;text-align:center;"><span class="font-weight-bold text-uppercase" style="font-size:14px;">Phone:</span><span class="ml-1" style="font-size:14px;">{{$phone}}</span></div>
                                <div style="margin:0px;text-align:center;"><span class="font-weight-bold text-uppercase" style="font-size:14px;">Fax:</span><span class="ml-1" style="font-size:14px;">{{$fax}}</span></div><br><br>
                                <div class=""><span class="font-weight-bold text-uppercase">Prescription no:</span><span class="ml-1">D00{{$doc_id}}A{{$number}}</span>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<span class="font-weight-bold text-uppercase">Date:</span><span class="ml-1" style="padding-right:10px;">{{$date}}&nbsp;&nbsp;&nbsp;&nbsp;</span></div>


                            </div>
                        </div>
                        <hr>

                        <div class="row">
                            <div class="col-md-12">
                                <p>Name: {{$patient}} </p>
                                <p>Sex : {{$sex}}</p>
                                @if($address != '')
                                <p style="padding-right:8px;">Address: {{$address}}</p>
                                @endif
                                <p> @if($dob != '')DOB: {{$dob}} @endif&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@if($age != '')Age : {{$age}} @endif&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@if($height != '')Height: {{$height}}"@endif&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;@if($weight != '')Weight: {{$weight}} lbs @endif&nbsp;&nbsp;</p>
                                <p class="text-uppercase text-left"><img src="https://nodeserver.mydevfactory.com/jajakul/Prescription/rx.png" style="height:60px;width:60px;"></p>
                            </div>

                        </div>


                        <div class="table-responsive">
                            <!-- <h4 style="color:#294876">Medicine Details</h4> -->
                            <table width="100%" style="border:1px solid black">
                                <thead style="background-color:#a2bba3">
                                    <tr>


                                        <th style="border:1px solid black;padding:5px;">Drug</th>
                                        <th style="border:1px solid black;padding:5px;">Dose</th>
                                        <th style="border:1px solid black;padding:5px;">Frequency</th>
                                        <th style="border:1px solid black;padding:5px;">Route</th>
                                        <th style="border:1px solid black;padding:5px;">Duration</th>
                                        <th style="border:1px solid black;padding:5px;">Refill</th>

                                    </tr>
                                </thead>

                                <tbody>
                                    @foreach($med as $row)
                                    <tr>
                                        <td style="border:1px solid black;padding:5px;">{{$row->medicine}}</td>
                                        <td style="border:1px solid black;padding:5px;">{{$row->dose}}</td>
                                        <td style="border:1px solid black;padding:5px;">{{$row->frequency}}</td>
                                        <td style="border:1px solid black;padding:5px;">{{$row->route_name}}</td>
                                        <td style="border:1px solid black;padding:5px;">{{$row->course}} Days</td>
                                        <td style="border:1px solid black;padding:5px;">{{$row->refil}}</td>
                                    </tr>
                                    @endforeach
                                </tbody>


                            </table>
                        </div>




                        <div class="row">
                            <div class="col-md-12" style="padding-top:5px;">
                                @if($remarks != '')
                                <p><b>Remarks : {{$remarks}}</b></p>
                                @endif


                                <!--div>
                                    <p style="margin-bottom:0;display:inline-block;"><b>Dispense as Written</b></p>
                                    @if($sub == 1)
                                    <p><b>May Substitute : Ok to substitute with generic <br>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;or formulary equivalent </b></p>
                                    @else
                                    <p><b>May Substitute :</b></p>
                                    @endif
                                </div>
                                <div style="width:325px; display:inline-block;text-align: right;float:right;margin-top:-60px;padding-right:27px;">
                                    <p style="margin-bottom:0;">
                                        <b> Dr. {{substr($doctor, 0, 50)}}</b>
                                    </p>

                                    <p><b>(Signature)</b></p>
                                </div-->
                                <div>
                                @if($sub == 1)
                                    
                                   
                                    <p><b>May Substitute : Ok to substitute with generic or formulary equivalent </b></p>
                                    @else
                                    <p style="margin-bottom:0;display:inline-block;"><b>Dispense as Written</b></p>
                                    @endif
                                </div>
                                <div style="width:95%;text-align:right;">
                                    <p style="margin-bottom:0;">
                                        <b> Dr. {{substr($doctor, 0, 50)}}</b>
                                    </p>

                                    <p><b>(Signature)</b></p>
                                </div>



                            </div>

                        </div>


                        <!-- <div>
                        <p style="color: #0075c9; margin-bottom: 0px;">Doctor App, Thank You Visit Again</p>
                    </div> -->

                    </div>
                </div>
            </div>
        </div>
    </div>
    <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
    <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
</body>

</html>