@extends('layout.admin_layout')

@section('title', 'Unapproved Doctors')

@section('body')
@section('header', 'Manage Unapproved Doctors')
@section('badge')

@endsection

@if(Session::has('message'))
<div class="alert alert-success">
    {{ Session::get('message') }}

</div>
@endif

@if(Session::has('error'))
<div class="alert alert-danger">
    {{ Session::get('error') }}

</div>
@endif

<div class="card card-primary card-outline">






    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Speciality</th>
                        <th>Status</th>
                        <th data-orderable="false">Action </th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 1;
                    ?>
                    @foreach($unappropved_doctors as $key=>$u_d)
                    <tr>

                        <td>


                            {{$i++}}
                        </td>
                        <td>Dr. {{$u_d->last_name}}</td>
                        <td>{{$u_d->email}}</td>

                        <td> <?php echo doctors_speciality($u_d->id); ?>

                            @if(doctors_speciality_count($u_d->id) > 3)
                            <a href="{{ URL::to('admin/approved_doctor/view') }}/{{$u_d->id}}">view more</a>
                            @endif
                        </td>
                        @if($u_d->status == 1)
                        <td><span class="badge bg-warning">Not verified</span></td>
                        @elseif($u_d->status == 3)
                        <td><span class="badge bg-danger">Disapproved</span></td>
                        @elseif($u_d->status == 4)
                        <td><span class="badge bg-info">Blocked</span></td>
                        @else
                        <td><span class="badge bg-secondary">OTP not verified</span></td>
                        @endif
                        <td>


                            <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to view" href="{{ URL::to('admin/doctor/view') }}/{{$u_d->id}}"> <i class="fas fa-eye"></i></a>

                            @if($u_d->multi == 2)
                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to approve multi specialization" href="{{ URL::to('admin/doctor/multi_spl_aprv') }}/{{$u_d->id}}/1"> <i class="fas fa-remove"></i></a>
                           
                            @endif
                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/doctor/edit') }}/{{$u_d->id}}"> <i class="fas fa-edit"></i></a>




                        </td>
                    </tr>
                    @endforeach



                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush