@extends('layout.admin_layout')

@section('title', 'Manage Route')

@section('body')

@section('header', 'Edit Route')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.route') }}">Route</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.route.add') }}">Add Route</a></li>
@endsection


<div class="card">
  
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach

    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.route.update') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Route Name <span class="text-danger">*</span></label>
                    <input type="hidden" name="id" class="form-control @error('name') is-invalid @enderror" value="{{ $data->id }}">
                    <div class="col-md-6">

                        <input type="text" name="route" id="location" class="form-control @error('name') is-invalid @enderror" value="{{ $data->route_name }}" maxlength="30" required>
                        @error('route')
                        <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection