@extends('layout.admin_layout')

@section('title', 'Manage Route')

@section('body')
@section('header', '
Manage Route')
@section('badge')
<li class="breadcrumb-item"><a href="">
       Manage Route</a></li>
@endsection



<div class="card card-primary card-outline">
    

    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:15px" >


            <div class="btn-group">


                <a href="" data-toggle="tooltip" title="" class="btn btn-default btn-sm" data-original-title="Refresh"><i class="fas fa-sync-alt"></i></a>
            </div>
            <a style="margin-left:12px"  href="{{ route('admin.route.add') }}" data-toggle="tooltip" title="" class="btn btn-primary btn-sm" data-original-title="Add Route"><i class="fas fa-plus-square"></i> New</a>

        </div>

        
    </div>



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Route Name</th>

                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($data as $key=>$value)
                    <tr>

              
                        <td>
                           
                                {{$key+1}}
                           
                        </td>
                        <td>{{$value->route_name}}</td>


                        <td>


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/route/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>

                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/route/delete') }}/{{$value->id}}"> <i class="fas fa-trash"></i></a>




                        </td>
                      
                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush