@extends('layout.admin_layout')

@section('title', 'Patient Details')

@section('body')

@section('header', 'Patient Details')
@section('badge')

<li class="breadcrumb-item"><a href="{{ route('admin.patient') }}">Patient Details</a></li>
@endsection


<div class="card">

    <div class="card-body">

        <a class="btn btn-sm btn-outline-success" style="text-align:right" data-placement="right" data-toggle="tooltip" title="Click to see earlier consultation record" href="{{ URL::to('admin/patient/appointment_list') }}/{{$patient->id}}"> Appointment List</a>



        <div class="card-body">

            <div class="form-group row">
                <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Profile Image:</span><br>

                    @if($patient->profile_image !== '')
                    <a href="{{$patient->profile_image}}" target="_blank"> <img src="{{asset($patient->profile_image)}}" class="img-circle img-fluid" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                    @else
                    <a href="#" target="_blank"> <img src="{{asset('images/noimage.png')}}" class="img-circle img-fluid" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                    @endif
                </p>
            </div>

            <div class="form-group row">
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Name:</span>
                    {{$patient->name}}

                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Email:</span>
                    {{$patient->email}}

                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Phone:</span>
                {{$patient->code}} {{$patient->phone}}

                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Gender:</span>
                    {{$patient->sex}}

                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Address:</span>
                    {{$patient->address}}

                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Date of Birth:</span>
                    {{date('m-d-Y',strtotime($patient->dob))}}

                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Height:</span>
                    @if($patient->height != ''){{$patient->height}}"@endif

                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Weight:</span>

                @if($patient->weight != ''){{$patient->weight}} lbs @endif
                   

                </p>
               
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Allergy:</span>
                    <span>
                        <?php
                        $users = json_decode(json_encode(patient_allergy($patient->id)), true);
                        $_add_on = array_column($users, 'allergy');
                        $allergy = implode(', ', $_add_on);

                        ?>
                        {{$allergy}}
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Medical History:</span>
                    <span>
                        <?php
                        $users = json_decode(json_encode(patient_medical($patient->id)), true);
                        $_add_on = array_column($users, 'medical');
                        $medical = implode(', ', $_add_on);

                        ?>

                        {{$medical}}


                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Surgical History:</span>
                    <span>
                        <?php
                        $users = json_decode(json_encode(patient_surgery($patient->id)), true);
                        $_add_on = array_column($users, 'surgery');
                        $surgery = implode(', ', $_add_on);

                        ?>

                        {{$surgery}}


                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Surgical Results:</span>
                    <span>
                        <?php
                        if ($patient->surgical_images != '') {


                            $s_results = explode(',', $patient->surgical_images);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }

                        ?>

                        @if($count == 0)

                        @else
                        @foreach($s_results as $row)
                        <?php
                        $ext = explode('.', $row);

                        ?>
                        @if($ext[3] == 'pdf')
                        <a href="{{$row}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        @else
                        <a href="{{$row}}" target="_blank"><img src="{{$row}}" style="height:50px;width:50px;" /></a>
                        @endif
                        @endforeach
                        @endif
                    </span>
                </p>
                <p class="col-md-2 form-control-label" for="name"><span style="font-weight:600;">Social History</span><br>
                    <span>
                        
                        @foreach(patient_social_history($patient->id) as $row)
                        {{$row->social_history}}<br>
                        @endforeach

                    </span>

                </p>
                <p class="col-md-2 form-control-label" for="name"><span style="font-weight:600;">Type</span><br>
                    <span>
                        <?php
                        $s_type = explode(',', $patient->social_history_type);

                        ?>
                        @foreach($s_type as $row)
                        {{$row}}<br>
                        @endforeach
                    </span>
                </p>
                <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Frequency</span><br>
                    <span>
                        <?php
                        $s_type = explode(',', $patient->frequency);

                        ?>
                        @foreach($s_type as $row)
                        {{$row}}<br>
                        @endforeach
                    </span>
                </p>


                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Medication History:</span>
                    <span>

                    <?php
                        $users = json_decode(json_encode(patient_medication($patient->id)), true);
                        $_add_on = array_column($users, 'title');
                        $title = implode(', ', $_add_on);

                        ?>

                        {{$title}}
                    
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name">
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Lab History:</span>
                    <span>

                    <?php
                        $users = json_decode(json_encode(patient_lab($patient->id)), true);
                        $_add_on = array_column($users, 'lab');
                        $lab = implode(', ', $_add_on);

                        ?>

                        {{$lab}}



                     
                    </span>
                </p>
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Lab Result:</span>
                    <span>
                        <?php
                        if ($patient->lab_result_images != '') {

                            $lab_results = explode(',', $patient->lab_result_images);
                            $count = count($lab_results);
                        } else {
                            $count = 0;
                        }

                        ?>
                        @if($count==0)

                        @else
                        @foreach($lab_results as $row)
                        <?php
                        $ext1 = explode('.', $row);

                        ?>
                        @if($ext1[3]==='pdf')
                        <a href="{{$row}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        @else

                        <a href="{{$row}}" target="_blank"><img src="{{$row}}" style="height:50px;width:50px;" /></a>
                        @endif
                        @endforeach
                        @endif

                    </span>

                </p>
                @if($patient->color !='')
                <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Health Condition:</span>
                    <span style="color:{{$patient->color}};font-weight:600">{{$patient->type}}({{$patient->color}})</span>
                </p>
                @endif
            </div>

        </div>

    </div>
    <div class="card-footer">
        <div class="col text-right">
            <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>


        </div>
    </div>

</div>
<!-- /.card-body -->

<!-- /.card-footer-->
</div>

@endsection