@extends('layout.admin_layout')

@section('title', 'Patient Create')

@section('body')

@section('header', 'Patient Create')
@section('badge')


@endsection


<div class="card">

    <div class="card-body">
        @foreach ($errors->all() as $error)
        <div class="alert alert-danger">
            {{ $error }}
        </div>
        @endforeach
        <form role="form" method="POST" action="{{ route('admin.patient_update') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Name <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <input type="text" name="name" id="name" class="form-control" required>

                    </div>
                    <label class="col-md-2 form-control-label" for="name">Email <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <input type="email" name="email" id="email" class="form-control" required>

                    </div>
                </div>

                <div class="form-group row">

                    <label class="col-md-2 form-control-label" for="name">Phone </label>
                    <div class="col-md-1">

                        <input type="hidden" name="country_code" class="form-control fil" id="country_code" value="US" placeholder="phone" autocomplete="off">
                        <input type="hidden" name="dial_code" class="form-control fil" id="dial_code" value="+1" placeholder="phone" autocomplete="off">
                        <input type="tel" name="code" class="form-control fil" id="code" autocomplete="off">

                    </div>


                    <div class="col-md-3">

                        <input type="text" name="phone" id="phone" maxlength="10" oninput="this.value=this.value.replace(/[^0-9]/g,'')" class="form-control" required>

                    </div>
                    <label class="col-md-2 form-control-label" for="name">Gender <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <select class="form-control" name="sex" id="sex" aria-label="Default select example" required>
                            <option value="">Select Gender</option>
                            <option value="Male">Male</option>
                            <option value="Female">Female</option>
                            <option value="Others">Others</option>
                        </select>



                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Address <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <input type="text" name="address" id="address" class="form-control" required>

                    </div>
                    <label class="col-md-2 form-control-label" for="name">DOB</label>

                    <div class="col-md-4">

                        <input type="text" name="dob" id="dob" class="form-control" value="<?php echo date("m/d/Y"); ?>" required>

                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Color Code <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <select class="form-control" name="color_code" id="color_code" required>
                            <option value="">Select Color Code</option>
                            @foreach($color as $key=>$value)
                            <option value="{{$value->id}}">{{$value->color}} ({{$value->type}})</option>
                            @endforeach
                        </select>

                    </div>




                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Profile Image</label>

                    <div class="col-md-4">
                        <input type="file" name="profile_image" id="profile_image" class="form-control">


                    </div>
                    <label class="col-md-2 form-control-label" for="name">Password <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <input type="password" name="password" id="password" class="form-control" required>

                    </div>


                </div>

            </div>




    </div>
    <div class="card-footer">
        <div class="col text-right">
            <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>
            <button type="submit" id="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>

        </div>
    </div>
    </form>
</div>
<!-- /.card-body -->

<!-- /.card-footer-->
</div>
<link rel="stylesheet" href="//code.jquery.com/ui/1.13.2/themes/base/jquery-ui.css">


<script src="https://code.jquery.com/ui/1.13.2/jquery-ui.js"></script>
<script>
  $( function() {
    $( "#dob" ).datepicker({  maxDate: 0 });
  } );
  
  </script>

<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=AIzaSyCyJ7Lirxe2ObjpsZbKTgeafLSA9bYSA0M&libraries=places"></script>
<script>
    $(document).ready(function() {
        $("#latitudeArea").addClass("d-none");
        $("#longtitudeArea").addClass("d-none");
    });
</script>

<script>
    google.maps.event.addDomListener(window, 'load', initialize);

    function initialize() {
        var input = document.getElementById('address');
        var autocomplete = new google.maps.places.Autocomplete(input);

        autocomplete.addListener('place_changed', function() {
            var place = autocomplete.getPlace();
            $('#latitude').val(place.geometry['location'].lat());
            $('#longitude').val(place.geometry['location'].lng());

            $("#latitudeArea").removeClass("d-none");
            $("#longtitudeArea").removeClass("d-none");
        });
    }
</script>





<script type="text/javascript">
    const email = document.querySelector('#email');
    const submit = document.querySelector('#submit');

    submit.addEventListener('click', () => {
        if (email.validity.typeMismatch) {
            email.setCustomValidity('Please include @ in the email address.');
        } else {
            email.setCustomValidity('');
        }
    })






    $('#allergy').select2({
        width: '100%',

        placeholder: "Select a Allergy",
        allowClear: true
    });

    function chk_allergy(value) {
        var str = $("#allergy :selected").map((_, e) => e.value).get();
        var str2 = '6';
        var index = str.indexOf("6");
        var index_n = str.indexOf('5');
        if (index !== -1) {

            $("#other_allergy_div").show();


        } else if (index_n !== -1) {
            $("#other_allergy_div").hide();

        } else {
            $("#other_allergy_div").hide();

        }



    }
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.js"></script>


<script>
    var code = $('#country_code').val();

    var input = document.querySelector("#code");
    var iti = window.intlTelInput(input, {
        formatOnDisplay: true,
        initialCountry: code,
        autoPlaceholder: "off",
        separateDialCode: true,
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js",
    });
    input.addEventListener("countrychange", function() {
        console.log(iti.getSelectedCountryData());

        $('#country_code').val(iti.getSelectedCountryData().iso2);
        $('#dial_code').val(iti.getSelectedCountryData().dialCode);

    });
</script>
@endsection