@extends('layout.admin_layout')

@section('title', 'Manage Patient')

@section('body')
@section('header', 'Manage Patient')
@section('badge')

@endsection



<div class="card card-primary card-outline">
  
    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding-left:12px;">


            <div class="btn-group">



            </div>
            <a href="{{ route('admin.patient_create') }}" data-toggle="tooltip" title="" class="btn btn-primary btn-sm" data-original-title="Create Patient"><i class="fas fa-plus-square"></i> Create Patient</a>

        </div>

      
    </div>

    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif


    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Gender</th>
                        <th>Status</th>
                        <th  data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($patients as $key=>$u_d)
                    <tr>

                        <td>
                           

                                {{$loop->iteration}}
                          
                        </td>
                        <td>{{$u_d->name}}</td>
                        <td>{{$u_d->email}}</td>

                        <td>
                            {{$u_d->sex}}


                        </td>
                        @if($u_d->status == 0)
                        <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/patient_status') }}/{{$u_d->id}}/1">Inactive</a></td>
                        @else
                        <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/patient_status') }}/{{$u_d->id}}/0" style="padding-left:13px;padding-right:13px;">Active</a></td>
                        @endif
                        <td>


                            <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to view" href="{{ URL::to('admin/patient/view') }}/{{$u_d->id}}"> <i class="fas fa-eye"></i></a>
                           
                           
                            <a class="btn btn-sm btn-outline-success" data-toggle="tooltip" title="Click to see earlier consultation record" href="{{ URL::to('admin/patient/appointment_list') }}/{{$u_d->id}}"> <i class="fa fa-list" aria-hidden="true"></i></a>


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/patient/edit') }}/{{$u_d->id}}"> <i class="fas fa-edit"></i></a>
                      



                        </td>
                    </tr>
                    @endforeach






                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush