@extends('layout.admin_layout')

@section('title', 'Give Permission')

@section('body')

@section('header', 'Give Permission')
@section('badge')

@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">{{$data->name}} ({{$data->email}})</h3>
    </div>

    <div class="card-body">
        @if($errors->any())


        <ul>
            @foreach ($errors->all() as $error)
            <li class="text-danger">{{ $error }}</li>
            @endforeach.
        </ul>

        @endif


        <form role="form" method="POST" action="{{ route('admin.give_permission_post') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <div class="card-body">
                <input class="form-check-input" name="id" type="hidden" value="{{$data->id}}">
                <div class="form-group row">
                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Dashboard" @if(chk_permission($data->id,'Dashboard')!==0) checked @endif>
                        Dashboard </label>


                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Settings" @if(chk_permission($data->id,'Settings')!==0) checked @endif>
                        Manage Profile </label>
                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="User Management" @if(chk_permission($data->id,'User Management')!==0) checked @endif>
                        User Management </label>

                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Manage Settings" @if(chk_permission($data->id,'Manage Settings')!==0) checked @endif >
                        Manage Settings</label>


                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Appointment" @if(chk_permission($data->id,'Appointment')!==0) checked @endif>
                        Appointment</label>

                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Quick Chat Bot" @if(chk_permission($data->id,'Quick Chat Bot')!==0) checked @endif>
                        Quick Chat Bot</label>

                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Medicine Change Request" @if(chk_permission($data->id,'Medicine Change Request')!==0) checked @endif>
                        Medicine Change Request
                        </label>

                        <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Complain List" @if(chk_permission($data->id,'Complain List')!==0) checked @endif>
                        Complain List
                        </label>
                        

                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Manage Quick Visit" @if(chk_permission($data->id,'Manage Quick Visit')!==0) checked @endif >
                        Manage Quick Visit </label>
                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Commission" @if(chk_permission($data->id,'Commission')!==0) checked @endif>
                        Commission </label>

                    <label class="col-md-3 form-control-label">
                        <input class="form-check-input" name="permission[]" type="checkbox" value="Manage Accessories" @if(chk_permission($data->id,'Manage Accessories')!==0) checked @endif >
                        Manage Accessories </label>



                </div>



            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ route('admin.sub_admin') }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>

    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection