@extends('layout.admin_layout')

@section('title', 'Unapproved Doctor Details')

@section('body')

@section('header', 'Unapproved Doctor Details')
@section('badge')

<li class="breadcrumb-item"><a href="{{ route('admin.unappropved_doctors') }}">Unapproved Doctor Details</a></li>
@endsection


<div class="card">

    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.route.store') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Profile Image:</span><br>
                        @if($doctor->profile_image!=='')
                        <a href="{{asset($doctor->profile_image)}}" target="_blank"> <img src="{{asset($doctor->profile_image)}}" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @else
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @endif
                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Doctor Id:</span>
                        DOC00{{$doctor->id}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Name:</span>
                    {{$doctor->name}} {{$doctor->last_name}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Email:</span>
                        {{$doctor->email}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Phone:</span>
                    {{$doctor->code}} {{$doctor->phone}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Gender:</span>
                        {{$doctor->sex}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Address:</span>
                        {{$doctor->address}}

                    </p>
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Skill Set / Specialization:</span>
                    {{doctors_speciality_m($doctor->id)}}

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">DEA:</span>
                    {{$doctor->dea}}
                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">License:</span>
                    {{$doctor->license}}
                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">NPI:</span>
                    {{$doctor->npi}}
                    </p>

                    @if($doctor->fee_per_consultation!='')
                    <?php
                    $fee = explode(',', $doctor->fee_per_consultation);



                    ?>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Video consultation fees:</span>
                    $ {{ $fee[0]}}

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Audio consultation fees:</span>
                    $ {{ $fee[1]}}

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Chat consultation fees:</span>
                    $ {{ $fee[2]}}
                        
                    </p>
                    @endif
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">State Practitional License:</span><br>
                        @if($doctor->certificate_practice!='')
                        <?php
                        $exp = explode('.', $doctor->certificate_practice);


                        ?>
                        @if($exp[1]=='pdf')
                        <a href="{{asset($doctor->certificate_practice)}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        @else
                        <a href="{{asset($doctor->certificate_practice)}}" target="_blank"> <img src="{{asset($doctor->certificate_practice)}}" style="height:100px;width:100px" title="Profile image" alt=""></a>
                       @endif
                        @else
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt=""></a>
                        @endif
                    </p>

                    <p class="col-md-8 form-control-label" for="name"><span style="font-weight:600;">Registration No of Practitional License:</span>
                        {{$doctor->reg_no_p}}

                    </p>
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">About:</span>
                        {{$doctor->about}}

                    </p>

                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;"><span style="font-weight:600;">Qualification</span><br>
                        <?php
                        if ($doctor->certificate_name != '') {
                       
                            $s_results = explode(',', $doctor->certificate_name);
                            $count = count($s_results);
                        
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <span style="padding:20px;"> {{$row}} </span>
                        <br><br>
                        @endforeach
                        @endif



                    </p>
                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;"for="name"><span style="font-weight:600;">Certificates</span><br>
                        <?php
                        if ($doctor->certificate_mbbs != '') {
                         
                            $s_results = explode(',', $doctor->certificate_mbbs);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <?php
                        $ext = explode('.', $row);

                        ?>
                        @if($ext[2]==="pdf")
                        <a href="{{$row}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        @else
                        <a href="{{$row}}" target="_blank"><img src="{{$row}}" style="height:50;width:50px;" /></a>
                        @endif
                        <br><br>
                        @endforeach
                        @endif


                    </p>

                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;"for="name"><span style="font-weight:600;">Registration No</span><br>
                        <?php
                        if ($doctor->registration_no != '') {
        
                            $s_results = explode(',', $doctor->registration_no);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }
                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <span style="padding:20px;"> {{$row}} </span>
                        <br><br>
                        @endforeach
                        @endif



                    </p>


                 


                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ route('admin.unappropved_doctors') }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>

                    <a href="{{ URL::to('admin/doctor/discard') }}/{{$doctor->id}}" class="btn btn-danger"><i class="far fa-arrow-alt-circle-left"></i> Discard</a>
                    <a href="{{ URL::to('admin/doctor/validate') }}/{{$doctor->id}}" class="btn btn-success"><i class="far fa-arrow-alt-circle-left"></i> Validate</a>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection