@extends('layout.admin_layout')

@section('title', 'Doctor Details')

@section('body')

@section('header', 'Doctor Details')
@section('badge')

<li class="breadcrumb-item"><a href="{{ route('admin.appropved_doctors') }}">Doctor Details</a></li>
@endsection


<div class="card">

    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.route.store') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Profile Image:</span><br>
                        @if($doctor->profile_image!='')
                        <a href="{{asset($doctor->profile_image)}}" target="_blank"> <img src="{{asset($doctor->profile_image)}}" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @else
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @endif
                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Doctor Id:</span>
                        DOC00{{$doctor->id}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Name:</span>
                        {{$doctor->name}} {{$doctor->last_name}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Email:</span>
                        {{$doctor->email}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Phone:</span>
                    {{$doctor->code}} {{$doctor->phone}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Gender:</span>
                        {{$doctor->sex}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Address:</span>
                        {{$doctor->address}}

                    </p>
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">Skill Set / Specialization:</span>
                        {{doctors_speciality_m($doctor->id)}}


                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">DEA:</span>
                        {{$doctor->dea}}
                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">License:</span>
                        {{$doctor->license}}
                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">NPI:</span>
                        {{$doctor->npi}}
                    </p>
                    <?php
                    $fee = explode(',', $doctor->fee_per_consultation);



                    ?>
                    @if($doctor->fee_per_consultation!='' && count($fee)==3)

                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Video consultation fees:</span>
                    $ {{$fee[0] }} 

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Audio consultation fees:</span>
                    $ {{$fee[1]}} 

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Chat consultation fees:</span>
                    $ {{$fee[2]}}

                    </p>
                    @endif

                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;">Practitional License:</span><br>
                        @if($doctor->certificate_practice!='')
                        <?php
                        $exp = explode('.', $doctor->certificate_practice);


                        ?>
                        @if($exp[3]=='pdf')
                        <a href="{{asset($doctor->certificate_practice)}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        @else
                        <a href="{{asset($doctor->certificate_practice)}}" target="_blank"> <img src="{{asset($doctor->certificate_practice)}}" style="height:100px;width:100px" title="Profile image" alt=""></a>
                        @endif
                        @else
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt=""></a>
                        @endif
                    </p>

                    <p class="col-md-8 form-control-label" for="name"><span style="font-weight:600;">Registration No of Practitional License:</span>
                        {{$doctor->reg_no_p}}

                    </p>
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">About:</span>
                        {{$doctor->about}}

                    </p>


                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;"><span style="font-weight:600;">Qualification</span><br>
                        <?php
                        if ($doctor->certificate_name != '') {

                            $s_results = explode(',', $doctor->certificate_name);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <span style="padding:20px;"> {{$row}} </span>
                        <br><br><br>
                        @endforeach
                        @endif



                    </p>
                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;" for="name"><span style="font-weight:600;">Certificates</span><br>
                        <?php
                        if ($doctor->certificate_mbbs != '') {
                            // $str = substr($doctor->certificate_mbbs, 0, -1);
                            $s_results = explode(',', $doctor->certificate_mbbs);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <?php
                        $ext = explode('.', $row);


                        ?>
                        @if($ext[3] === "pdf")
                        <a href="{{$row}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        <br><br>
                        @else
                        <a href="{{$row}}" target="_blank"><img src="{{$row}}" style="height:50px;width:50px;" /></a>
                        <br><br>
                        @endif
                        @endforeach
                        @endif


                    </p>

                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;" for="name"><span style="font-weight:600;">Registration No</span><br>
                        <?php
                        if ($doctor->registration_no != '') {

                            $s_results = explode(',', $doctor->registration_no);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }
                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <span style="padding:20px;"> {{$row}} </span>
                        <br><br><br>
                        @endforeach
                        @endif



                    </p>
                    @if(count(avl_doc($doctor->id))>0)
                    <p class="col-md-12 form-control-label"><span style="font-weight:600;"><u>Availability:</u>
                            (&#128992;Booked
                            &#128994;Available)
                        </span>
                        </p>
                 
                   
                    @endif


                </div>  
                 @if(count(avl_doc($doctor->id))>0)

                <table id="example2" class="table table-hover table-striped">
                        <thead>
                            <tr>
                                <th scope="col" width="5%">No</th>
                                <th scope="col" width="10%">Date</th>
                                <th scope="col" width="20%">Time Duration</th>
                                <th scope="col" width="20%">Slot Duration</th>
                                <th scope="col" width="25%">Patient</th>
                                <th scope="col" width="15%">Consultation Type</th>


                            </tr>
                        </thead>
                        <tbody>
                            @foreach(avl_doc($doctor->id) as $key=>$row)

                            <tr>
                                <th>{{$key+1}}</th>
                                <td>{{$row->day}},{{date( 'm/d/Y', strtotime($row->date))}} ({{$row->type}})</td>
                                <td>
                                    <?php
                                    $start_time = date('h:i a', strtotime(get_change_utc_to_timezone($row->start_time, 'America/New_York')));

                                    $end_time = date('h:i a', strtotime(get_change_utc_to_timezone($row->end_time, 'America/New_York')));
                                    ?>

                                    {{$start_time}} to {{ $end_time}}
                                </td>
                                <?php
                                $id = $row->id;
                                $duration = time_slot();  // split by 30 mins
                                $u_id = $row->user_id;

                                ?>
                                <td id="slot_{{$row->id}}" style="display:none;">
                                    <?php

                                    $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->start_time, 'America/New_York')));

                                    $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->end_time, 'America/New_York')));


                                    $duration = time_slot();

                                    $slots = getTimeSlot($duration, $start_time, $end_time);



                                    //  $slots = getTimeSlot($duration, $row->start_time, $row->end_time);

                                    foreach ($slots  as $row1) {

                                        $date =  date('Y/m/d/', strtotime($row->date));
                                        $t = getBookingDtl($u_id, $row1['slot_start_time'], $row1['slot_end_time'], $date, 'America/New_York');

                                        $newTime = date('H:i', strtotime($row1['slot_end_time']) - (1 * 60));
                                        if ($t !== 0) {
                                            echo '<span  style="color:#DC582A">' . $t . '</span><br>';
                                        } else {
                                            echo '<span  style="color:green">' . $row1['slot_start_time'] . ' to ' . $newTime . '</span><br>';
                                        }
                                    }



                                    ?>

                                    <a href="#" data-toggle="tooltip" title="Click to hide time slots" onClick="rmv_slot({{$id}})"><i class="fas fa-remove"></i></a>

                                </td>

                                <td id="slot_t_{{$id}}">

                                    <a href="#" data-toggle="tooltip" title="Click to view time slots" onClick="ckh_slot({{$id}})"><i class="fas fa-eye"></i></a>


                                </td>
                                <td id="slot_d_{{$id}}"></td>
                                <td id="slot_d1_{{$id}}"></td>
                                <td id="slot_d2_{{$id}}"></td>

                                <td id="slot_p_{{$id}}" style="display:none">
                                    <?php
                                    $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->start_time, 'America/New_York')));

                                    $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->end_time, 'America/New_York')));


                                    $duration = time_slot();

                                    $slots = getTimeSlot($duration, $start_time, $end_time);

                                    foreach ($slots  as $row1) {
                                        $date =  date('Y/m/d/', strtotime($row->date));
                                        $t = getBookingDtlP($u_id, $row1['slot_start_time'], $row1['slot_end_time'], $date, 'America/New_York');
                                        if ($t !== 0) {
                                            $t = explode('-',$t);
                                            echo  $t[0] . '<br>';
                                        } else {
                                            echo  'NA<br>';
                                        }
                                    }



                                    ?>


                                </td>

                                <td id="slot_p1_{{$id}}" style="display:none">
                                    <?php
                                      $start_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->start_time, 'America/New_York')));

                                      $end_time = date('H:i:s', strtotime(get_change_utc_to_timezone($row->end_time, 'America/New_York')));
  
  
                                      $duration = time_slot();
  
                                      $slots = getTimeSlot($duration, $start_time, $end_time);

                                    foreach ($slots  as $row1) {
                                        $date =  date('Y/m/d/', strtotime($row->date));
                                        $t = getBookingDtlT($u_id, $row1['slot_start_time'], $row1['slot_end_time'], $date);
                                        if ($t !== 0) {
                                            echo  $t . '<br>';
                                        } else {
                                            echo  'NA<br>';
                                        }
                                    }



                                    ?>


                                </td>


                            </tr>
                            @endforeach
                        </tbody>
                    </table>
                    @endif
          
                </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>


                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script>
    function ckh_slot(id) {
        $('#slot_' + id).show();
        $('#slot_t_' + id).hide();
        $('#slot_p_' + id).show();
        $('#slot_p1_' + id).show();
        $('#slot_p2_' + id).show();
        $('#slot_d_' + id).hide();
        $('#slot_d1_' + id).hide();
        $('#slot_d2_' + id).hide();

    }

    function rmv_slot(id) {
        $('#slot_' + id).hide();
        $('#slot_t_' + id).show();
        $('#slot_p_' + id).hide();
        $('#slot_p1_' + id).hide();
        $('#slot_p2_' + id).hide();
        $('#slot_d_' + id).show();
        $('#slot_d1_' + id).show();
        $('#slot_d2_' + id).show();
    }
</script>
@endsection