@extends('layout.admin_layout')

@section('title', 'Doctor Edit')

@section('body')

@section('header', 'Doctor Edit')
@section('badge')
<style>
    .select2-container--default .select2-selection--multiple .select2-selection__choice {

        color: black;
    }
</style>
@endsection
@if(Session::has('message'))
<div class="alert alert-success">
    {{ Session::get('message') }} <a class="btn btn-danger" @if($type=='Approved' )href="{{ route('admin.appropved_doctors') }}" @else href="{{ route('admin.unappropved_doctors') }}" @endif>Back</a>

</div>
@endif
@foreach ($errors->all() as $error)
<div class="alert alert-danger">
    {{ $error }}
</div>
@endforeach

<div class="card">
    <div class="card-header">
        <h3 class="card-title">{{$type}} Doctor Edit</h3>
    </div>
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.doctor.update') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">First Name <span class="text-danger">*</span></label>
                    <input type="hidden" name="id" class="form-control" value="{{ $doctor->id }}">
                    <div class="col-md-4">

                        <input type="text" name="name" id="name" class="form-control" value="{{ $doctor->name }}" required>

                    </div>

                    <label class="col-md-2 form-control-label" for="name">Last Name <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <input type="text" name="last_name" id="last_name" class="form-control" value="{{ $doctor->last_name }}" required>

                    </div><br><br>
                    <label class="col-md-2 form-control-label" for="name">Email </label>

                    <div class="col-md-4">

                        <input type="text" name="email" id="email" class="form-control" value="{{ $doctor->email }}" required disabled>

                    </div>
                </div>

                <div class="form-group row">

                    <label class="col-md-2 form-control-label" for="name">Phone <span class="text-danger">*</span></label>

                    <div class="col-md-1">

                        <input type="hidden" name="country_code" class="form-control fil" id="country_code" value="{{$doctor->country}}" placeholder="phone" autocomplete="off">
                        <input type="hidden" name="dial_code" class="form-control fil" id="dial_code" value="{{$doctor->code}}" placeholder="phone" autocomplete="off">
                        <input type="tel" name="code" class="form-control fil" value="{{$doctor->code}}" id="code" autocomplete="off">

                    </div>
                    <div class="col-md-3">

                        <input type="text" name="phone" id="phone" class="form-control" value="{{ $doctor->phone }}" maxlength="10" oninput="this.value=this.value.replace(/[^0-9]/g,'')" required>

                    </div>
                    <label class="col-md-2 form-control-label" for="name">Sex <span class="text-danger">*</span></label>

                    <div class="col-md-4">

                        <select class="form-control" name="sex" id="sex" aria-label="Default select example" required>

                            <option value="Male" @if($doctor->sex == 'Male') selected @endif>Male</option>
                            <option value="Female" @if($doctor->sex == 'Female') selected @endif>Female</option>
                            <option value="Others" @if($doctor->sex == 'Others') selected @endif >Others</option>
                        </select>



                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Address <span class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="address" id="address" class="form-control" value="{{ $doctor->address }}" required>

                    </div><br><br>
                    <label class="col-md-2 form-control-label" for="name">Skill Set / Specialization <span class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <select class="form-control" name="skill[]" id="skill" multiple required>
                            @foreach(doctors_speciality_n($doctor->id) as $spl)
                            <option value="{{$spl->id}}" selected>{{$spl->name}}</option>
                            @endforeach
                            @foreach(doctors_speciality_ns($doctor->id) as $spl)
                            <option value="{{$spl->id}}">{{$spl->name}}</option>
                            @endforeach
                        </select>






                    </div>
                </div>
                <div class="form-group row" style="display:none;">
                    <div class="form-group" id="latitudeArea">
                        <label>Latitude</label>
                        <input type="text" id="latitude" name="latitude" class="form-control">
                    </div>
                    <div class="form-group" id="longtitudeArea">
                        <label>Longitude</label>
                        <input type="text" name="longitude" id="longitude" class="form-control">
                    </div>
                </div>


                <div class="form-group row">

                    <?php
                    $fee = explode(',', $doctor->fee_per_consultation);
                    if ($doctor->fee_per_consultation == '') {
                        $fee = explode(',', '0,0,0');
                    }



                    ?>
                    <label class="col-md-2 form-control-label" for="name">Video Consultation Fees <span class="text-danger">*</span></label>

                    <div class="col-md-2">

                        <input type="number" name="fee_per_consultation_1" id="fee_per_consultation_1" class="form-control" value="{{ $fee[0]}}" min="1" max="1000" required>

                    </div>


                    <label class="col-md-2 form-control-label" for="name">Audio Consultation Fees <span class="text-danger">*</span></label>

                    <div class="col-md-2">

                        <input type="number" name="fee_per_consultation_2" id="fee_per_consultation_2" class="form-control" value="{{ $fee[1]}}" min="1" max="1000" required>

                    </div>
                    <label class="col-md-2 form-control-label" for="name">Chat Consultation Fees <span class="text-danger">*</span></label>

                    <div class="col-md-2">

                        <input type="number" name="fee_per_consultation_3" id="fee_per_consultation_3" class="form-control" value="{{ $fee[2]}}" min="1" max="1000" required>

                    </div>
                </div>
                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Profile Image</label>
                    <div class="col-md-8 custom-file">
                        <input type="file" class="custom-file-input" name="profile_image" id="inputGroupFile01">
                        @if($doctor->profile_image!='')
                        <label class="custom-file-label" for="inputGroupFile01">{{$doctor->profile_image}}</label>
                        @else
                        <label class="custom-file-label" for="inputGroupFile01">Choose Image</label>
                        @endif
                    </div>
                </div>

                <div class="form-group row">


                    <div class="col-md-4">


                        <input type="hidden" name="profile_image_old" id="profile_image_old" class="form-control" value="{{ $doctor->profile_image }}">
                        <br>
                        @if($doctor->profile_image!='')
                        <a href="{{asset($doctor->profile_image)}}" target="_blank"> <img src="{{asset($doctor->profile_image)}}" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @else
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @endif
                    </div>

                </div>
                <!--div class="form-group row">

                    <label class="col-md-2 form-control-label" for="name">Certificate Practice:</label>

                    <div class="col-md-4">
                        <input type="file" name="certificate_practice" id="certificate_practice" class="form-control">
                        <br>
                        <input type="hidden" name="certificate_practice_old" id="certificate_practice_old" class="form-control" value="{{ $doctor->certificate_practice }}">
                        @if($doctor->certificate_practice!='')
                        <a href="{{asset($doctor->certificate_practice)}}" target="_blank"> <img src="{{asset($doctor->certificate_practice)}}" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @else
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                        @endif
                    </div>
                    <label class="col-md-2 form-control-label" for="name">Registration No of Practitional License:</label>

                    <div class="col-md-4">
                        <input type="text" name="reg_no_p" id="reg_no_p" value="{{$doctor->reg_no_p}}" class="form-control">


                    </div>

                </div-->
                <!--div class="form-group row">

                    <label class="col-md-2 form-control-label" for="name">Certificates:</label>

                    <div class="col-md-1">
                        <?php
                        if ($doctor->certificate_mbbs != '') {

                            $s_results = explode(',', $doctor->certificate_mbbs);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <?php
                        $ext = explode('.', $row);
                        //echo $ext[3];
                        ?>
                        @if($ext[3] === "pdf")
                        <a href="{{$row}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        @else
                        <a href="{{$row}}" target="_blank"><img src="{{$row}}" style="height:50px;width:50px;" /></a>
                        @endif
                        @endforeach
                        @endif
                    </div>
                    <label class="col-md-2 form-control-label" for="name">Qualification:</label>

                    <div class="col-md-2">
                        <?php
                        if ($doctor->certificate_name != '') {

                            $s_results = explode(',', $doctor->certificate_name);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <input type="text" name="certificate_name[]" id="certificate_name" value="{{$row}}" class="form-control">

                        @endforeach
                        @endif




                    </div>
                    <label class="col-md-2 form-control-label" for="name">Registration No:</label><br>

                    <div class="col-md-3">
                        <?php
                        if ($doctor->registration_no != '') {

                            $s_results = explode(',', $doctor->registration_no);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }
                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <input type="text" name="reg_no[]" id="reg_no" value="{{$row}}" class="form-control">

                        @endforeach
                        @endif



                    </div>

                </div>
            </div-->
                <div class="card-footer">
                    <div class="col text-right">
                        <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                        <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>

                    </div>
                </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

<script type="text/javascript" src="https://maps.google.com/maps/api/js?key=AIzaSyCyJ7Lirxe2ObjpsZbKTgeafLSA9bYSA0M&libraries=places"></script>
<script>
    $(document).ready(function() {
        $("#latitudeArea").addClass("d-none");
        $("#longtitudeArea").addClass("d-none");
    });
</script>

<script>
    google.maps.event.addDomListener(window, 'load', initialize);

    function initialize() {
        var input = document.getElementById('address');
        var autocomplete = new google.maps.places.Autocomplete(input);

        autocomplete.addListener('place_changed', function() {
            var place = autocomplete.getPlace();
            $('#latitude').val(place.geometry['location'].lat());
            $('#longitude').val(place.geometry['location'].lng());

            $("#latitudeArea").removeClass("d-none");
            $("#longtitudeArea").removeClass("d-none");
        });
    }
</script>



<script>
    $(document).ready(function() {
        $('#inputGroupFile01').on('change', function() {
            //get the file name
            var fileName = $(this).val();
            //replace the "Choose a file" label
            $(this).next('.custom-file-label').html(fileName);
        })
    })
</script>
<script language="javascript">
    var today = new Date();
    var dd = String(today.getDate()).padStart(2, '0');
    var mm = String(today.getMonth() + 1).padStart(2, '0');
    var yyyy = today.getFullYear();

    today = yyyy + '-' + mm + '-' + dd;
    $('#mbbs_validate_date').attr('min', today);
    $('#practice_validate_date').attr('min', today);
</script>
<script type="text/javascript">
    $('#skill').select2({
        width: '100%',

        placeholder: "Select Skill",
        allowClear: true
    });
</script>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/css/intlTelInput.css" />
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.8/js/intlTelInput.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/intlTelInput.js"></script>


<script>
    var code = $('#country_code').val();

    var input = document.querySelector("#code");
    var iti = window.intlTelInput(input, {
        formatOnDisplay: true,
        initialCountry: code,
        autoPlaceholder: "off",
        separateDialCode: true,
        utilsScript: "https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/11.0.9/js/utils.js",
    });
    input.addEventListener("countrychange", function() {
        console.log(iti.getSelectedCountryData());

        $('#country_code').val(iti.getSelectedCountryData().iso2);
        $('#dial_code').val(iti.getSelectedCountryData().dialCode);

    });
</script>

@endsection