@extends('layout.admin_layout')

@section('title', 'Discard Doctor with Reason')

@section('body')

@section('header', 'Discard Doctor with Reason')
@section('badge')


<li class="breadcrumb-item"><a href="{{ route('admin.unappropved_doctors') }}">Discard Doctor with Reason</a></li>
@endsection


<div class="card">

    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.doctor.doctor_disappropved') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">
                <div class="form-group row">
                    <input type="hidden" name="id" class="form-control" value="{{ $doctor->id }}">
                    <label class="col-md-12 form-control-label" for="zip">Reason <span class="text-danger">*</span></label>

                    <div class="col-md-6">
                        <select name="reason[]" id="reason" style="background-color:black" multiple required>
                            @foreach($reasons as $row)
                            <option value="{{$row->reason}}">{{$row->reason}}</option>
                            @endforeach
                        </select>

                    </div>
                </div>
                <div class="form-group row">


                    <div class="col-md-6">
                        <textarea class="form-control" name="note" placeholder="Note"></textarea>

                    </div>
                </div>

                <div class="form-group row">
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Name:</span>
                        {{$doctor->name}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Email:</span>
                        {{$doctor->email}}
                        <input type="hidden" name="email" id="email" class="form-control" value="{{ $doctor->email }}">
                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Phone:</span>
                        {{$doctor->phone}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Sex:</span>
                        {{$doctor->sex}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Address:</span>
                        {{$doctor->address}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Skill Set / Specilization:</span>
                    {{doctors_speciality($doctor->id)}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Qualification:</span>
                        {{$doctor->qualification}}

                    </p>
                    @if($doctor->fee_per_consultation!='')
                    <?php
                    $fee = explode(',', $doctor->fee_per_consultation);



                    ?>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Video consultation fee:</span>
                        {{ $fee[0]}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Audio consultation fee:</span>
                        {{ $fee[1]}}

                    </p>
                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Chat consultation fee:</span>
                        {{ $fee[2]}}

                    </p>
                    @endif
                    <p class="col-md-12 form-control-label" for="name"><span style="font-weight:600;">
                           

                    <input class="form-check-input" name="profile_photo_check" type="checkbox" value="1" id="defaultCheck1">    Profile Image:</span><br>
                        @if($doctor->profile_image!='')
                       
                        <a href="{{asset($doctor->profile_image)}}" target="_blank"> <img src="{{asset($doctor->profile_image)}}" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                       
                        
                        
                        @else
                      
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                       
                        
                       
                        @endif

                    </p>
                    <p class="col-md-4 form-control-label" for="name"><span style="font-weight:600;"><input class="form-check-input" name="profile_photo_check" type="checkbox" value="1" id="defaultCheck1">Certificate Practice:</span><br>
                        @if($doctor->certificate_practice!='')
                       
                        <a href="{{asset($doctor->certificate_practice)}}" target="_blank"> <img src="{{asset($doctor->certificate_practice)}}" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>
                       
                      
                       
                       
                        @else
                      
                        <a href="../../../images/noimage.png" target="_blank"> <img src="../../../images/noimage.png" style="height:100px;width:100px" title="Profile image" alt="alt text here"></a>

                       
                        @endif
                    </p>

                    <p class="col-md-6 form-control-label" for="name"><span style="font-weight:600;">Registration No of Practitional License:</span>
                        {{$doctor->reg_no_p}}

                    </p>
                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;" for="name"><span style="font-weight:600;"><u>Qualifications</u></span><br>
                        <?php
                        if ($doctor->certificate_name != '') {

                            $s_results = explode(',', $doctor->certificate_name);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <span style="padding:20px;"> {{$row}} </span>
                        <br><br>
                        @endforeach
                        @endif



                    </p>
                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;" for="name"><span style="font-weight:600;"><u>Certificates</u></span><br>
                
                      <?php
                        if ($doctor->certificate_mbbs != '') {
       
                            $s_results = explode(',', $doctor->certificate_mbbs);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }


                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                
                        <?php
                        $ext = explode('.', $row);

                        ?>
                         
                        @if($ext[1]=='pdf')
                       
                        <a href="{{$row}}" target="_blank"><i class="fa fa-file" aria-hidden="true"></i></a>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input class="form-check-input" name="profile_photo_check"  type="checkbox" value="1" id="defaultCheck1">
                        @else
         
                        
                        <a href="{{$row}}" target="_blank"><img src="{{$row}}" style="height:50;width:50px;" /></a>
                        &nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<input class="form-check-input" name="profile_photo_check" type="checkbox" value="1" id="defaultCheck1">
                        @endif
                        
                        <br><br>
                        @endforeach
                        
                        @endif
                    

                    </p>
                    <p class="col-md-4 form-control-label" style="border:1px solid #D9D9D9;" for="name"><span style="font-weight:600;"><u>Registration No</u></span><br>
                        <?php
                        if ($doctor->registration_no != '') {

                            $s_results = explode(',', $doctor->registration_no);
                            $count = count($s_results);
                        } else {
                            $count = 0;
                        }
                        ?>
                        @if($count==0)

                        @else
                        @foreach($s_results as $row)
                        <span style="padding:20px;"> {{$row}} </span>
                        <br><br>
                        @endforeach
                        @endif



                    </p>






                </div>

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-danger"><i class="far fa-save"></i> Disapproved</button>


                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script type="text/javascript">
    $('#reason').select2({
        width: '100%',

        placeholder: "Select a Reason",
        allowClear: true
    });
</script>
@endsection