@extends('layout.admin_layout')

@section('title', 'Manage Approved Doctors')

@section('body')
@section('header', 'Manage Approved Doctors')
@section('badge')

@endsection


@if(Session::has('message'))
<div class="alert alert-success">
    {{ Session::get('message') }}

</div>
@endif

<div class="card card-primary card-outline">
   

 



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Speciality</th>
                    
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($appropved_doctors as $key=>$u_d)
                    <tr>

                        <td>
                            

                            {{$loop->iteration}}
                           
                        </td>
                        <td>Dr. {{$u_d->last_name}}</td>
                        <td>{{$u_d->email}}</td>
                       
                      
                        <td> <?php echo doctors_speciality($u_d->id); ?>
                        
                        
                        @if(doctors_speciality_count($u_d->id) > 3)
                        <a href="{{ URL::to('admin/approved_doctor/view') }}/{{$u_d->id}}">view more</a>
                        @endif
                        
                        </td>
                        
                       
                        
                     
                      
                        <td>


                            <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to view" href="{{ URL::to('admin/approved_doctor/view') }}/{{$u_d->id}}"> <i class="fas fa-eye"></i></a>
<!-- 
                            <a class="btn btn-sm btn-outline-success" data-toggle="tooltip" title="Click to Block" href="https://registered-doctor.com/admin/user/block/463"> <i class="fas fa-ban"></i></a> -->
                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to block" href="{{ URL::to('admin/doctor/unapproved') }}/{{$u_d->id}}"> <i class="fa fa-ban" aria-hidden="true"></i></a> 


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/doctor/edit') }}/{{$u_d->id}}"> <i class="fas fa-edit"></i></a>
                            <!-- <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" onclick="return confirm('Are you sure want to delete?');" href="{{ URL::to('admin/doctor/delete') }}/{{$u_d->id}}"> <i class="fas fa-trash-alt"></i></a> -->
                            @if($u_d->multi == 2)
                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to approve multi specialization" href="{{ URL::to('admin/doctor/multi_spl_aprv') }}/{{$u_d->id}}/1"> <i class="fas fa-remove"></i></a>
                           
                            @endif


                        </td>
                    </tr>
                    @endforeach
                    
                   
                    
                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush