@extends('layout.admin_layout')

@section('title', 'Previous Appointments List')

@section('body')
@section('header', 'Previous Appointments List')
@section('badge')

@endsection



<div class="card card-primary card-outline">
    <div class="card-header">
        <h3 class="card-title">{{$user->name}} ({{$user->email}})</h3>
    </div>

    <div class="row">


        <div class="card-tools col-md-10" style="padding-left:15px;">
           



                    <div class="input-group-append">
                        <?php

                        $u= $_SERVER['REQUEST_URI'];
                        $p=explode('/',$u);
                        $r=count($p)-1;

                        ?>
                        <a class="btn btn-info" href="https://doctorapp.mydevfactory.com/doctorAPP/public/admin/patient/view/{{$p[$r]}}"><i class="fa fa-arrow-left" aria-hidden="true"></i> Back</a>

                    </div>
                </div>
          

        </div>

 




    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>DateTime</th>
                        <th>Doctor</th>
                   
                        <th>Status</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                @foreach($appointments as $key=>$u_d)
                    <tr>

                        <td>
                        

                              {{$key+1}}
                           
                        </td>
                        <td>{{date('m-d-Y',strtotime($u_d->date))}}</td>
                        <td>Dr. {{$u_d->doctor->last_name}}</td>
                      
                        @if($u_d->status == 1)
                        <td><span class="badge bg-warning">CNA</span></td>
                        @elseif($u_d->status == 2)
                        <td><span class="badge bg-success">Completed</span></td>
                        @else
                        <td><span class="badge bg-danger">Cancelled</span></td>
                        @endif
                        <td>
                            <a class="btn btn-sm btn-outline-primary" data-toggle="tooltip" title="Click to view" href="{{ URL::to('admin/appointment/view') }}/{{$u_d->id}}"> <i class="fas fa-eye"></i></a>

                    
                        </td>
                    </tr>
                    @endforeach
                 
              
                
               
                    
                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush