@extends('layout.admin_layout')

@section('title', 'Sub Admin Users')

@section('body')

@section('header', 'Edit Sub Admin')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.route') }}">Sub Admin</a></li>
<li class="breadcrumb-item"><a href="{{ route('admin.route.add') }}">Edit Sub Admin</a></li>
@endsection

    
<div class="card">
    <div class="card-header">
        <h3 class="card-title">Edit Sub Admin</h3>
    </div>

    <div class="card-body">
    @if($errors->any())
           
                
           <ul>
               @foreach ($errors->all() as $error)
               <li class="text-danger">{{ $error }}</li>
               @endforeach.
           </ul>

       @endif
        <form role="form" method="POST" action="{{ route('admin.admin_update') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}
           

                <div class="card-body">

                    <div class="form-group row">
                        <label class="col-md-1 form-control-label" for="name">Name <span class="text-danger">*</span></label>

                        <div class="col-md-5">
                        <input type="hidden" name="id" id="id" class="form-control" value="{{$data->id}}" required>
                            <input type="text" name="name" id="name" class="form-control" value="{{$data->name}}" required>

                        </div>
                        <label class="col-md-1 form-control-label" for="name">Email </label>

                        <div class="col-md-5">

                            <input type="text" name="email" id="email" class="form-control" value="{{$data->email}}" required disabled>

                        </div>


                    </div>
              

                </div>
                <div class="card-footer">
                    <div class="col text-right">
                        <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Back</a>
                        <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>
                    </div>
                </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection