@extends('layout.admin_layout')

@section('title', 'Sub Admin Users')

@section('body')
@section('header', 'Sub Admin Users')
@section('badge')

@endsection



<div class="card card-primary card-outline">
 

    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding-left:15px;">


            <div class="btn-group">



            </div>
            <a href="{{ route('admin.admin_create') }}" data-toggle="tooltip" title="" class="btn btn-primary btn-sm" data-original-title="Add Sub Admin"><i class="fas fa-plus-square"></i> Create Sub Admin</a>

        </div>


    </div>

    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }}
    </div>
    @endif

    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Name</th>
                        <th>Email</th>
                        <th>Status</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    <?php
                    $i = 1;

                    ?>
                    @foreach($sub_admins as $key=>$u_d)
                    <tr>

                        <td>


                            {{$i++}}

                        </td>
                        <td>{{$u_d->name}}</td>
                        <td>{{$u_d->email}}</td>
                        @if($u_d->status == 0)
                        <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/admin_status') }}/{{$u_d->id}}/1"  >Inactive</a></td>
                        @else
                        <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/admin_status') }}/{{$u_d->id}}/0" style="padding-left:12px;padding-right:12px;" >Active</a></td>
                        @endif

                        <td>
                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/sub_admin_edit') }}/{{$u_d->id}}"> <i class="fas fa-edit"></i></a>
                            <a class="btn btn-sm btn-outline-info" data-toggle="tooltip" title="Click to give permission" href="{{ URL::to('admin/give_permission') }}/{{$u_d->id}}"> <i class="fas fa-cogs"></i></a>
                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/delete') }}/{{$u_d->id}}"> <i class="fa fa-trash"></i></a>
                        </td>
                    </tr>
                    @endforeach





                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush