@extends('layout.admin_layout')

@section('title', 'Complaint Related Questions')

@section('body')
@section('header', '
Complaint Related Questions')
@section('badge')
<li class="breadcrumb-item"><a href="">
Complaint Related Questions</a></li>
@endsection



<div class="card card-primary card-outline">
   

    <div class="row">
        <div class="mailbox-controls col-md-9"  style="padding:20px;">

            <!--a href="{{ route('admin.import_questions') }}" data-toggle="tooltip" title="Import Questions" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Import</a-->

            <a href="{{ route('admin.s_type.add') }}" data-toggle="tooltip" title="Add Complaint Related Questions" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add</a>

        </div>


    </div>
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }}
    </div>
    @endif



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Chief Complaint</th>
                        <th>Questions</th>
                        <th>Order</th>
                        <th data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($data as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{$value->problem}}</td>
                        <td>{{$value->type}}</td>
                        <td>{{$value->order}}</td>

                        <td>

                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/type/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>
                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/type/delete') }}/{{$value->id}}"> <i class="fas fa-trash"></i></a>

                        </td>

                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush