@extends('layout.admin_layout')

@section('title', 'Complaint Related Questions')

@section('body')

@section('header', 'Complaint Related Questions')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.s_type.add') }}">Add Complaint Related Questions</a></li>

@endsection


<div class="card">
    
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach
    @if(Session::has('message'))
    <div class="alert alert-danger">
        {{ Session::get('message') }} 
    </div>
    @endif


    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.s.create') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Problems <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="pro_id" required>
                            <option value="">Select</option>
                            @foreach(problems() as $value)
                            <option value="{{$value->id}}" >{{ $value->problem }} - {{$value->age_b}}
                            </option>
                            @endforeach
                        </select>
                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Questions <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" name="question" id="type" class="form-control" maxlength="50" required>

                    </div>


                </div>

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Sequence <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="order" required>
                            <option value="">Select</option>
                            @for($i=1; $i<=10 ;$i++)
                            <option value="{{$i}}" >{{$i}}
                            </option>
                            @endfor
                        </select>
                    </div>


                </div>


            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>

</div>

@endsection