@extends('layout.admin_layout')

@section('title', 'Differential Diagnosis')

@section('body')
@section('header', '
Differential Diagnosis')
@section('badge')
<li class="breadcrumb-item"><a href="">
Differential Diagnosis</a></li>
@endsection



<div class="card card-primary card-outline">
   
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }}
    </div>
    @endif

    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:20px">

        <!--a href="{{ route('admin.import_diagnosis') }}" data-toggle="tooltip" title="Import Diagnosis" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Import</a-->

            <a href="{{ route('admin.symptoms.add') }}" data-toggle="tooltip" title="Add Differential Diagnosis" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add</a>



        </div>




        <div class="card-body p-3">

            <div class="table-responsive mailbox-messages">
                <table id="example2" class="table table-hover table-striped">

                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Symptoms</th>
                            <th>Diagnosis</th>



                            <th data-orderable="false">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($data as $key=>$value)
                        <tr>


                            <td>

                                {{$key+1}}

                            </td>
                            <td>{{$value->problem}} ({{$value->age_b}}) with ({{$value->symptoms}})</td>

                            <td> <?php echo substr($value->diagnosis, 0, 50); ?> ...<a href="{{ URL::to('admin/differential_diagnosis/edit') }}/{{$value->id}}">view more</a></td>


                            <td>

                                <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/differential_diagnosis/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>
                                <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/differential_diagnosis/delete') }}/{{$value->id}}"> <i class="fas fa-trash"></i></a>
                            </td>

                        </tr>
                        @endforeach


                    </tbody>



                </table>

            </div>
        </div>



    </div>



    @endsection
    @push('scripts')

    @endpush