@extends('layout.admin_layout')

@section('title', 'Differential Diagnosis')

@section('body')

@section('header', 'Differential Diagnosis')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.body_cat.add') }}">Differential Diagnosis</a></li>

@endsection


<div class="card">
   
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.symptoms.update') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}
            <input type="hidden" value="{{$data_p->id}}" name="id" />

            <div class="card-body row">

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Symptoms <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="symp_id" required>
                            @foreach($data as $value)
                            <option value="{{$value->id}}" @if($data_p->symp_id == $value->id) selected @endif>{{ $value->problem }} with ({{$value->symptoms}})
                            </option>
                            @endforeach
                        </select>
                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Diagnosis<span class="text-danger">*</span></label>

                    <div class="col-md-8" style="margin-top:-23px">
                        <textarea name="diagnosis" id="diagnosis" class="form-control" maxlength="200" >{{$data_p->diagnosis}}</textarea>


                    </div>


                </div>



            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{route('admin.symptoms')}}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection