@extends('layout.admin_layout')

@section('title', 'Delete Chief Complaint Related Records')

@section('body')

@section('header', 'Delete Chief Complaint Related Records')
@section('badge')
<li class="breadcrumb-item"><a href="#">Delete Chief Complaint Related Records</a></li>

@endsection
<style>
.select2-container--default .select2-selection--multiple .select2-selection__choice {
    color: black;
    border: 1px solid #aaa;
    border-radius: 4px;
    cursor: default;
    float: left;
    margin-right: 5px;
    margin-top: 5px;
    padding: 0 5px;
}
    </style>
    


<div class="card">
    
    <div class="card-body">
        @if(Session::has('message'))
        <div class="alert alert-success">
            {{ Session::get('message') }}
        </div>
        @endif

        <form role="form" method="POST" action="{{ route('admin.delete_problems_post') }}" enctype='multipart/form-data' id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">

                    <label class="col-md-2 form-control-label">Age <span class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <select name="age" id="age" class="form-control" required>
                            <option value="">Select</option>
                            <option value="Adult">Adult</option>
                            <option value="Both">Both</option>
                            <option value="Pediatric">Pediatric</option>

                        </select>

                    </div>
                </div>

                <div class="form-group row">

                    <label class="col-md-2 form-control-label">Chief Complaint <span class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <select name="pro_id[]" id="pro_id" class="form-control" multiple>
                            <option value="">Select</option>
                        </select>

                    </div>
                </div>



            </div>
            <div class="card-footer">
                <div class="col text-right">

                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script type="text/javascript">
    $('#pro_id').select2({
        width: '100%',

        placeholder: "Select a Chief Complaint",
        allowClear: true
    });
</script>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.6.2/jquery.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#age').on('change', function(e) {
            var age = e.target.value;
            $.ajax({
                url: "{{ route('admin.getProblem') }}",
                type: "GET",
                data: {
                    age: age
                },
                success: function(data) {


                    if (data) {
                        $('#pro_id').empty();
                        $('#pro_id').append('<option value="All" hidden >All</option>');
                        $.each(data, function(key, value) {
                            $('select[id="pro_id"]').append('<option value="' + value.id + '">' + value.problem + '</option>');
                        });
                    } else {
                        $('#pro_id').empty();
                    }
                }
            })
        });
    });
</script>

@endsection