@extends('layout.admin_layout')

@section('title', 'Surgery')

@section('body')

@section('header', 'Surgery')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.surgeries') }}">Surgery</a></li>

@endsection


<div class="card">
   
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.surgery.editSurgery') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <input type="hidden" name="id" id="id" value="{{$data->id}}" class="form-control"  required>
            <div class="card-body row">

                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Surgery <span class="text-danger">*</span></label>
       
                    <div class="col-md-8">

                        <input type="text" name="surgery" id="surgery" value="{{$data->surgery}}"  maxlength="50" class="form-control"  required>
                       
                    </div>
                   
                    
                </div>
              
             
            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection