@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', 'Subscription Details')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.subscription.index') }}">Subscriptions</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.subscription.show', $store->id) }}">Subscription Details</a></li>
@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Subscription Details</h3>
    </div>
    <div class="card-body">

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Subscription Title :</label>

            <div class="col-md-9">
                {{ $store->name }}
            </div>
            <!--col-->
        </div>

        {{-- @if (!empty($store->image))

        <div class="form-group row">
            <label class="col-md-3 form-control-label">Image :</label>
            <div class="col-md-9">
                <img width="100px" height="100px" src="{{ asset('public/uploads/category/' . $store->image) }}">

            </div>
        </div>
        @endif --}}
        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Subscription Time :</label>

            <div class="col-md-9">

                {{  subscribtionDays($store->valid_form) }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Subscription Price ($) :</label>

            <div class="col-md-9">
                {{  $store->price }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Storage :</label>

            <div class="col-md-9">
                {{  $store->full_storage }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Image Count :</label>

            <div class="col-md-9">
                {{  $store->image_count }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Video Count :</label>

            <div class="col-md-9">
                {{  $store->video_count }}
            </div>
        </div>

        <div class="form-group row">
            <label class="col-md-3 form-control-label" for="name">Subscription Features :</label>

            <div class="col-md-9">
                {{  $store->feature }}
            </div>
        </div>
    </div>
    <!-- /.card-body -->
    <div class="card-footer">
        <div class="col text-right">
            <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                    class="far fa-arrow-alt-circle-left"></i> Back</a>
        </div>
    </div>
    <!-- /.card-footer-->
</div>

@endsection
