@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')

@section('header', 'Add Subscription')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.subscription.index') }}">Subscriptions</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.subscription.create') }}">Add Subscription</a></li>
@endsection


<div class="card">
    <div class="card-header">
        <h3 class="card-title">Subscription</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('admin.subscription.store') }}" method="POST" enctype="multipart/form-data"
            id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Subscription Title <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="name" id="inputName" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" maxlength="191" required>
                        @error('name')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Subscription Time <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <select name="valid_form" id="valid_form" class="form-control @error('valid_form') is-invalid @enderror" required>
                            <option value="">Select subscription time</option>
                            <option value="1 M" {{ (old('valid_form') == '1 M') ? "selected" : "" }}>1 Month ( 30days )</option>
                            <option value="2 M" {{ (old('valid_form') == '2 M') ? "selected" : "" }}>2 Month ( 60 days )</option>
                            <option value="3 M" {{ (old('valid_form') == '3 M') ? "selected" : "" }}>3 Month ( 90 days )</option>
                            <option value="6 M" {{ (old('valid_form') == '6 M') ? "selected" : "" }}>6 Month (180 days)</option>
                            <option value="12 M" {{ (old('valid_form') == '12 M') ? "selected" : "" }}>1 years ( 360 days)</option>
                        </select>
                        @error('valid_form')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Subscription Price ($) <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="price" id="inputName" class="form-control @error('price') is-invalid @enderror" value="{{ old('price') }}" maxlength="191" required>
                        @error('price')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Storage  <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <div class='inline_input'>
                            <select name="storage_unit">
                                <option value="MB">MB</option>
                                <option value="GB">GB</option>
                            </select>
                            <input type="number" name="storage" id="inputName" class="form-control @error('storage') is-invalid @enderror" value="{{ old('storage') }}" maxlength="191" required>

                        </div>
                        @error('storage')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Image Count <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="image_count" id="inputName" class="form-control @error('image_count') is-invalid @enderror" value="Unlimited" maxlength="191" readonly>
                        @error('image_count')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Video Count <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="number" name="video_count" id="inputName" class="form-control @error('video_count') is-invalid @enderror" value="{{ old('video_count') }}" maxlength="191" required>
                        @error('video_count')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Subscription Features <span
                            class="text-danger"></span></label>

                    <div class="col-md-10">
                        <input type="text" name="feature" id="inputName" class="form-control @error('feature') is-invalid @enderror" value="{{ old('feature') }}" maxlength="150" required>
                        @error('feature')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>
            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
