@extends('layout.admin_layout')

@section('title', 'Diagnosis')

@section('body')
@section('header', '
Diagnosis')
@section('badge')
<li class="breadcrumb-item"><a href="">
Diagnosis</a></li>
@endsection



<div class="card card-primary card-outline">
  
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }}
    </div>
    @endif

    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding:20px;">

        <a href="{{ route('admin.import_treatments') }}" data-toggle="tooltip" title="Import Treatments" class="btn btn-info btn-sm"><i class="fa fa-plus"></i> Import</a>

            <a href="{{ route('admin.sub_cat_add') }}" data-toggle="tooltip" title="Add Treatments" class="btn btn-primary btn-sm"><i class="fa fa-plus"></i> Add</a>



        </div>
       



        <div class="card-body p-3">

            <div class="table-responsive mailbox-messages">
                <table id="example2" class="table table-hover table-striped">

                    <thead>
                        <tr>
                            <th>No</th>
                            <th>Treatment</th>
                            <th>Color Code</th>
                   
                            <th>Status</th>

                            <th data-orderable="false">Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach($data as $key=>$value)
                        <tr>


                            <td>

                                {{$key+1}}

                            </td>
                            <td>{{$value->treatments}}</td>
                            <td><button class="btn btn-basic"style="background-color:{{$value->color}};"></button> {{$value->color}}</td>

                           
                    
                            @if($value->status == 1)
                            <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/diagnosis/status') }}/{{$value->id}}/0" style="padding-left:13px;padding-right:13px;">Active</a></td>
                            @else
                            <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/diagnosis/status') }}/{{$value->id}}/1">Inactive</a></td>
                            @endif

                            <td>
            
                                <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/diagnosis/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>

                                <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/diagnosis/delete') }}/{{$value->id}}"> <i class="fas fa-trash"></i></a>
                            </td>

                        </tr>
                        @endforeach


                    </tbody>



                </table>

            </div>
        </div>



    </div>



    @endsection
    @push('scripts')

    @endpush