@extends('layout.admin_layout')

@section('title', 'Diagnosis')

@section('body')

@section('header', 'Diagnosis')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.sub_cat_add') }}">Diagnosis</a></li>

@endsection


<div class="card">
    
    @foreach ($errors->all() as $error)
    <div class="alert alert-danger">
        {{ $error }}
    </div>
    @endforeach
    <div class="card-body">
        <form role="form" method="POST" action="{{ route('admin.body_subcat.create') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body row">
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Color Code <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <select class="form-control" name="color_code" id="color_code" required>
                        <option value="">Select
                            </option>
                            @foreach($data as $value)
                            <option value="{{$value->id}}">{{$value->color}}
                            </option>
                            @endforeach
                        </select>
                    </div>


                </div>
                <div class="col-md-12">
                    <label class="col-md-4 form-control-label" for="name">Diagnosis <span class="text-danger">*</span></label>

                    <div class="col-md-8">

                        <input type="text" class="form-control" name="treatment" maxlength="50" required/>
                    </div> 


                </div>
               


            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{route('admin.sub_cat_index')}}" class="btn btn-outline-danger"><i class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script type="text/javascript" src="http://ajax.googleapis.com/ajax/libs/jquery/1.6.2/jquery.min.js"></script>
<script type="text/javascript">
    $(document).ready(function() {
        $('#p_cat_id').on('change', function(e) {
            var p_cat_id = e.target.value;
            $.ajax({
                url: "{{ route('admin.getCat') }}",
                type: "GET",
                data: {
                    p_cat_id: p_cat_id
                },
                success: function(data) {

                 
                    if (data) {
                        $('#cat_id').html(data);
                    } else {
                        $('#cat_id').empty();
                    }
                }
            })
        });
    });
</script>
@endsection