@extends('layout.admin_layout')

@section('title', 'Payment Status')

@section('body')

@section('header', 'Payment Status')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.payment_status') }}">Payment Status</a></li>
@endsection


<div class="alert alert-success" id="pay" style="display:none">
Payment status updated successfully

</div>

@if ($errors->any())
@foreach ($errors->all() as $error)
<div class="alert alert-danger">{{$error}}</div>
@endforeach
@endif
<div class="card">
    <div class="card-header">
        <h5 class="card-title">@if($data->status == 1)To book appointment patient needs to do payment @else Consultation will be free for all patient @endif</h5>
    </div>
    <div class="card-body">
        @if(empty($data))
        <form role="form" method="POST" action="{{ route('admin.payment_status_post') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <div class="card-body">


                <div class="form-group row">


                    <div class="col-md-6">

                        <input type="radio" id="type" name="status" value="1" required>
                        <label for="huey">Enable</label>
                        <input type="radio" id="type" name="status" value="0">
                        <label for="dewey">Disable</label>
                        <br>
                    </div>


                </div>

            </div>
           
        </form>
        @else
        <form role="form" method="POST" action="{{ route('admin.payment_status_post') }}" enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <input type="hidden" id="id" name="id" value="{{$data->id}}">
            <div class="card-body">


                <div class="form-group row">


                    <div class="col-md-6">
                        <input type="radio" id="type" name="status" value="1" onchange="sts_update(this.value)" @if($data->status == 1) checked @endif required>
                        <label for="huey">Enable</label>

                        <input type="radio" id="type" name="status" value="0" onchange="sts_update(this.value)" @if($data->status == 0) checked @endif required>
                        <label for="dewey">Disable</label>
                        <br>



                    </div>


                </div>

            </div>
            
        </form>
        @endif
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
<script src="https://ajax.googleapis.com/ajax/libs/jquery/1.7.1/jquery.min.js" type="text/javascript"></script>
<script>
    function sts_update(value) {
       
        var id = $('#id').val();
        $.ajax({
            url: "{{ route('admin.payment_status_post') }}",
            type: "GET",
            data: {
                status: value,
                id: id
            },
            success: function(data) {

                $('#pay').show();

            }
        })


    }
</script>