@extends('layout.admin_layout')

@section('title', 'Slot Time')

@section('body')

@section('header', 'Slot Time')
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.slot_time') }}">Slot Time</a></li>

@endsection
@if(Session::has('message'))
<div class="alert alert-success">
    {{ Session::get('message') }}
</div>
@endif

<div class="card">
    <div class="card-header">
         <div class="card-header">
        <h5 class="card-title">
        This time slot will be apply for chat, audio and video consolation</h>
    </div>
    </div>
    <div class="card-body">
        @empty($slot_time)
        <form role="form" method="POST" action="{{ route('admin.slot_time_post') }}">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Slot Time<span class="text-danger">*</span></label>

                    <div class="col-md-2">

            

                        <input type="number" name="slot" id="slot" class="form-control" min="1" max="99" required/>
                   


                    </div>
                    <div class="col-md-1">
                        <select name="type" id="type" class="form-control" name="type">
                            <option value="hr">hr</option>
                            <option value="min">min</option>
                        </select>



                    </div>
                    <!--col-->
                </div>
              
              
            </div>
            <div class="card-footer">
                <div class="col text-right">

                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
        @else
        <form role="form" method="POST" action="{{ route('admin.slot_time_post') }}">
            {{ csrf_field() }}


            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Slot Time<span class="text-danger">*</span></label>

                    <div class="col-md-2">
                        <?php
                        $a_qty = $slot_time->slot;
                        $qt = intval($a_qty);

                        $result_u = preg_replace("/[^a-zA-Z]+/", "", $slot_time->slot);
                        ?>
                        <input type="hidden" name="id" class="form-control" value="{{$slot_time->id}}">
                        <input type="number" name="slot" class="form-control" value="{{$qt}}" min="1" max="99" required>

                    </div>
                    <div class="col-md-1">
                        <select  id="type" class="form-control" name="type">
                            <option value="hr" @if($result_u=='hr' ) selected @endif>hr</option>
                            <option value="min" @if($result_u=='min' ) selected @endif>min</option>
                        </select>



                    </div>
                    <!--col-->
                </div>
               
                
            </div>
            <div class="card-footer">
                <div class="col text-right">

                    <button type="submit" class="btn btn-warning"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
        @endif

    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection