@extends('layout.admin_layout')

@section('title', $title.$title_2)

@section('body')
@section('header', $title.$title_2)
@section('badge')
<li class="breadcrumb-item"><a href="{{ route('admin.cms_list') }}">{{$title}}</a></li>
<li class="breadcrumb-item"><a href="#">{{$title_2}}</a></li>
@endsection

<!-- /.col -->

<div class="card card-primary card-outline">
    <div class="card-header">
        <a href="{{ route('admin.cms_list') }}" class="btn btn-info btn-sm"><i class="fa fa-arrow-left"></i> Back to list</a>
        <a href="{{ route('admin.cms_edit', $dataRow->id) }}" class="btn btn-warning btn-sm"><i class="fa fa-edit"></i> Edit</a>
        <!-- <h3 class="card-title">{{$title}}</h3> -->

        <!-- /.card-tools -->
    </div>
    <!-- /.card-header -->
    <div class="card-body p-0">
        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">
                <tbody>
                    <tr>
                        <th>Page Name</th>
                        <td>{{$dataRow->page_name}}</td>
                    </tr>
                    <tr>
                        <th> Title</th>
                        <td>{{$dataRow->title}}</td>
                    </tr>

                    <tr>
                        <th> Description</th>
                        <td>{!! $dataRow->description !!}</td>
                    </tr>
                    <tr>
                        <th> Meta Title</th>
                        <td>{!! $dataRow->meta_title !!}</td>
                    </tr>
                    <tr>
                        <th> Meta Description</th>
                        <td>{!! $dataRow->meta_description !!}</td>
                    </tr> 
                </tbody>



            </table>
            <!-- /.table -->
        </div>
        <!-- /.mail-box-messages -->
    </div>
    <!-- /.card-body -->

</div>
<!-- /.card -->

<!-- /.col -->


@endsection
@push('scripts')

@endpush