@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', 'Edit Speciality')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.service.index') }}">Speciality</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.service.edit', $storeDetailsById->id) }}">Edit Speciality</a></li>
@endsection

<div class="card">

    <div class="card-body">
        <form role="form" action="{{ route('admin.service.update', $storeDetailsById->id) }}" method="POST"
            enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <div class="card-body">

                <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Speciality <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <input class="form-control @error('name') is-invalid @enderror" type="text" name="name"
                            id="name" placeholder="Speciality" maxlength="40" value="{{ $storeDetailsById->name }}" required>
                        @error('name')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

            </div>

            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-outline-primary"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
