@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')

@section('header', 'Add Speciality')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('admin.service.index') }}">Speciality</a></li>
    <li class="breadcrumb-item"><a href="{{ route('admin.service.create') }}">Add Speciality</a></li>
@endsection


<div class="card">
 
    <div class="card-body">
        <form role="form" action="{{ route('admin.service.store') }}" method="POST" enctype="multipart/form-data"
            id="cmsForm">
            {{ csrf_field() }}


            <div class="card-body">
            <div class="form-group row">
                    <label class="col-md-2 form-control-label" for="name">Speciality <span
                            class="text-danger">*</span></label>

                    <div class="col-md-10">

                        <input type="text" name="name" id="inputName" class="form-control @error('name') is-invalid @enderror" value="{{ old('name') }}" maxlength="40" required>
                        @error('name')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                    <!--col-->
                </div>

                <!-- <div class="form-group row">
                    
                    <label class="col-md-2 form-control-label" for="zip">Diagonosis <span class="text-danger">*</span></label>

                    <div class="col-md-10">
                        <select name="treatments[]" id="treatments" style="background-color:black" multiple required>
                            @foreach($data as $row)
                            <option value="{{$row->id}}">{{$row->treatments}}</option>
                            @endforeach
                        </select>

                    </div>
                </div> -->

            </div>
            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-primary"><i class="far fa-save"></i> Submit</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>
<script type="text/javascript">
    $('#treatments').select2({
        width: '100%',

        placeholder: "Select diaginosis",
        allowClear: true
    });
</script>
@endsection
