@extends('layout.admin_layout')

@section('title', 'admin-dashboard')

@section('body')
@section('header', '
Manage Reason')
@section('badge')
<li class="breadcrumb-item"><a href="">
        Manage Reason</a></li>
@endsection



<div class="card card-primary card-outline">
    

    <div class="row">
        <div class="mailbox-controls col-md-9" style="padding-left:12px;">


            <div class="btn-group">


                <a href="" data-toggle="tooltip" title="" class="btn btn-default btn-sm" data-original-title="Refresh"><i class="fas fa-sync-alt"></i></a>
            </div>
            <a href="{{ route('admin.reasons.add') }}" data-toggle="tooltip" title="" class="btn btn-primary btn-sm" data-original-title="Add Reason"><i class="fas fa-plus-square"></i> New</a>

        </div>


    </div>
    @if(Session::has('message'))
    <div class="alert alert-success">
        {{ Session::get('message') }} 
    </div>
    @endif



    <div class="card-body p-3">

        <div class="table-responsive mailbox-messages">
            <table id="example2" class="table table-hover table-striped">

                <thead>
                    <tr>
                        <th>No</th>
                        <th>Reason</th>
                        <th>Status</th>
                        <th  data-orderable="false">Action</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($reasons as $key=>$value)
                    <tr>


                        <td>

                            {{$key+1}}

                        </td>
                        <td>{{$value->reason}}</td>

                        @if($value->status == 0)
                        <td><a class="btn btn-sm btn-danger" data-toggle="tooltip" title="Click to active" href="{{ URL::to('admin/reason_status') }}/{{$value->id}}/1">Inactive</a></td>
                        @else
                        <td><a class="btn btn-sm btn-success" data-toggle="tooltip" title="Click to inactive" href="{{ URL::to('admin/reason_status') }}/{{$value->id}}/0" style="padding-left:13px;padding-right:13px;">Active</a></td>
                        @endif

                        <td>


                            <a class="btn btn-sm btn-outline-warning" data-toggle="tooltip" title="Click to edit" href="{{ URL::to('admin/reasons/edit') }}/{{$value->id}}"> <i class="fas fa-edit"></i></a>

                            <a class="btn btn-sm btn-outline-danger" data-toggle="tooltip" title="Click to delete" href="{{ URL::to('admin/reasons_delete') }}/{{$value->id}}"> <i class="fas fa-trash"></i></a>




                        </td>

                    </tr>
                    @endforeach


                </tbody>



            </table>

        </div>
    </div>



</div>



@endsection
@push('scripts')

@endpush