@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
@section('header', 'Edit Video Gallery')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.vediogallery.index') }}">Video Gallery</a></li>
    <li class="breadcrumb-item"><a href="{{ route('pub.vediogallery.edit', $storeDetailsById->id) }}">Edit Video Gallery</a></li>
@endsection

<div class="card">
    <div class="card-header">
        <h3 class="card-title">Video Gallery Edit</h3>
    </div>
    <div class="card-body">
        <form role="form" action="{{ route('pub.vediogallery.update', $storeDetailsById->id) }}" method="POST"
            enctype="multipart/form-data" id="cmsForm">
            {{ csrf_field() }}

            <div class="card-body">

                @if (!empty($storeDetailsById->image))

                <div class="form-group row">
                    <div class="col-md-2"></div>
                    <div class="col-md-10">
                        {{-- <img width="100px" height="100px" src="{{ asset('public/uploads/gallery/' . $storeDetailsById->image) }}"> --}}
                        <video width="320" height="240" controls>
                            <source src="{{ asset('public/uploads/gallery/video/' . $storeDetailsById->image) }}" type="{{ $storeDetailsById->media_type }}">
                            {{-- <source src="movie.ogg" type="video/ogg"> --}}
                            Your browser does not support the video tag.
                        </video>
                        {{-- <br> --}}
                    </div>
                </div>
                @endif
                <div class="form-group row">


                    <label class="col-md-2 form-control-label" for="name">Video </label>


                    <div class="col-md-10">
                        <input class="form-control @error('image') is-invalid @enderror" type="file" name="image"
                            id="image">
                        @error('image')
                            <span class="error invalid-feedback" id="error_description">{{ $message }}</span>
                        @enderror
                    </div>
                </div>

            </div>

            <div class="card-footer">
                <div class="col text-right">
                    <a href="{{ url()->previous() }}" class="btn btn-outline-danger"><i
                            class="far fa-arrow-alt-circle-left"></i> Cancel</a>
                    <button type="submit" class="btn btn-outline-primary"><i class="far fa-save"></i> Update</button>
                </div>
            </div>
        </form>
    </div>
    <!-- /.card-body -->

    <!-- /.card-footer-->
</div>

@endsection
