@extends('layout.pub_layout')

@section('title', 'vendor-dashboard')

@section('body')
@section('header', 'Coupon Lists')
@section('badge')
    <li class="breadcrumb-item"><a href="{{ route('pub.coupon.index') }}">Coupon</a></li>
@endsection
@if (!empty($subscription))
    <div class="subscription-alert-info">
        <span class="subscription-icon"></span>
        <p>Your paid subscription valid upto {{ date('d M, Y', strtotime($subscription->subscription_end)) }}</p>
        <i class="d-info-icon"></i>
    </div>
@endif
@empty($subscription)

    <div class="row">
        <div class="col-md-6 col-lg-12 d-mrtt-30">
            <div class="d-card-item-body d-item-2">

            <a href="{{ route('subscriptions') }}" class="updatesub">Click hear for update your Subscription</a>
            </div>
        </div>
    </div>

@endempty
@if (!empty($subscription))
    <div class="row">
        <div class="col-md-6 col-lg-12 d-mrtt-30">
            <div class="d-card-item-body d-item-2">
                <div>
                    <p>
                        <span class="count-num">{{ $subscription->subscription->name }}</span>
                    </p>
                    <p>
                        Date : {{ date('d F, Y', strtotime($subscription->subscription_end)) }}<br>
                        Price : $ {{ $subscription->orginal_price }}
                    </p>
                </div>
                <a href="{{ route('subscriptions') }}" class="updatesub">Click hear for update your
                    Subscription</a>
            </div>

        </div>
    </div>
@endif

@endsection
@push('scripts')

@endpush
